/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc;

import com.alibaba.nacos.api.grpc.auto.Payload;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.utils.ReflectUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.remote.BaseRpcServer;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.grpc.GrpcBiStreamRequestAcceptor;
import com.alibaba.nacos.core.remote.grpc.GrpcRequestAcceptor;
import com.alibaba.nacos.core.utils.Loggers;
import com.google.protobuf.Message;
import io.grpc.Attributes;
import io.grpc.CompressorRegistry;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.DecompressorRegistry;
import io.grpc.Grpc;
import io.grpc.HandlerRegistry;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServerTransportFilter;
import io.grpc.internal.ServerStream;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.grpc.util.MutableHandlerRegistry;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseGrpcServer
extends BaseRpcServer {
    private Server server;
    private static final String REQUEST_BI_STREAM_SERVICE_NAME = "BiRequestStream";
    private static final String REQUEST_BI_STREAM_METHOD_NAME = "requestBiStream";
    private static final String REQUEST_SERVICE_NAME = "Request";
    private static final String REQUEST_METHOD_NAME = "request";
    private static final String GRPC_MAX_INBOUND_MSG_SIZE_PROPERTY = "nacos.remote.server.grpc.maxinbound.message.size";
    private static final long DEFAULT_GRPC_MAX_INBOUND_MSG_SIZE = 0xA00000L;
    @Autowired
    private GrpcRequestAcceptor grpcCommonRequestAcceptor;
    @Autowired
    private GrpcBiStreamRequestAcceptor grpcBiStreamRequestAcceptor;
    @Autowired
    private ConnectionManager connectionManager;
    static final Attributes.Key<String> TRANS_KEY_CONN_ID = Attributes.Key.create((String)"conn_id");
    static final Attributes.Key<String> TRANS_KEY_REMOTE_IP = Attributes.Key.create((String)"remote_ip");
    static final Attributes.Key<Integer> TRANS_KEY_REMOTE_PORT = Attributes.Key.create((String)"remote_port");
    static final Attributes.Key<Integer> TRANS_KEY_LOCAL_PORT = Attributes.Key.create((String)"local_port");
    static final Context.Key<String> CONTEXT_KEY_CONN_ID = Context.key((String)"conn_id");
    static final Context.Key<String> CONTEXT_KEY_CONN_REMOTE_IP = Context.key((String)"remote_ip");
    static final Context.Key<Integer> CONTEXT_KEY_CONN_REMOTE_PORT = Context.key((String)"remote_port");
    static final Context.Key<Integer> CONTEXT_KEY_CONN_LOCAL_PORT = Context.key((String)"local_port");
    static final Context.Key<Channel> CONTEXT_KEY_CHANNEL = Context.key((String)"ctx_channel");

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.GRPC;
    }

    @Override
    public void startServer() throws Exception {
        MutableHandlerRegistry handlerRegistry = new MutableHandlerRegistry();
        ServerInterceptor serverInterceptor = new ServerInterceptor(){

            public <T, S> ServerCall.Listener<T> interceptCall(ServerCall<T, S> call, Metadata headers, ServerCallHandler<T, S> next) {
                Context ctx = Context.current().withValue(CONTEXT_KEY_CONN_ID, (Object)((String)call.getAttributes().get(TRANS_KEY_CONN_ID))).withValue(CONTEXT_KEY_CONN_REMOTE_IP, (Object)((String)call.getAttributes().get(TRANS_KEY_REMOTE_IP))).withValue(CONTEXT_KEY_CONN_REMOTE_PORT, (Object)((Integer)call.getAttributes().get(TRANS_KEY_REMOTE_PORT))).withValue(CONTEXT_KEY_CONN_LOCAL_PORT, (Object)((Integer)call.getAttributes().get(TRANS_KEY_LOCAL_PORT)));
                if (BaseGrpcServer.REQUEST_BI_STREAM_SERVICE_NAME.equals(call.getMethodDescriptor().getServiceName())) {
                    Channel internalChannel = BaseGrpcServer.this.getInternalChannel(call);
                    ctx = ctx.withValue(CONTEXT_KEY_CHANNEL, (Object)internalChannel);
                }
                return Contexts.interceptCall((Context)ctx, call, (Metadata)headers, next);
            }
        };
        this.addServices(handlerRegistry, serverInterceptor);
        this.server = ServerBuilder.forPort((int)this.getServicePort()).executor((Executor)this.getRpcExecutor()).maxInboundMessageSize(this.getInboundMessageSize()).fallbackHandlerRegistry((HandlerRegistry)handlerRegistry).compressorRegistry(CompressorRegistry.getDefaultInstance()).decompressorRegistry(DecompressorRegistry.getDefaultInstance()).addTransportFilter(new ServerTransportFilter(){

            public Attributes transportReady(Attributes transportAttrs) {
                InetSocketAddress remoteAddress = (InetSocketAddress)transportAttrs.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
                InetSocketAddress localAddress = (InetSocketAddress)transportAttrs.get(Grpc.TRANSPORT_ATTR_LOCAL_ADDR);
                int remotePort = remoteAddress.getPort();
                int localPort = localAddress.getPort();
                String remoteIp = remoteAddress.getAddress().getHostAddress();
                Attributes attrWrapper = transportAttrs.toBuilder().set(TRANS_KEY_CONN_ID, (Object)(System.currentTimeMillis() + "_" + remoteIp + "_" + remotePort)).set(TRANS_KEY_REMOTE_IP, (Object)remoteIp).set(TRANS_KEY_REMOTE_PORT, (Object)remotePort).set(TRANS_KEY_LOCAL_PORT, (Object)localPort).build();
                String connectionId = (String)attrWrapper.get(TRANS_KEY_CONN_ID);
                Loggers.REMOTE_DIGEST.info("Connection transportReady,connectionId = {} ", (Object)connectionId);
                return attrWrapper;
            }

            public void transportTerminated(Attributes transportAttrs) {
                String connectionId = null;
                try {
                    connectionId = (String)transportAttrs.get(TRANS_KEY_CONN_ID);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (StringUtils.isNotBlank(connectionId)) {
                    Loggers.REMOTE_DIGEST.info("Connection transportTerminated,connectionId = {} ", (Object)connectionId);
                    BaseGrpcServer.this.connectionManager.unregister(connectionId);
                }
            }
        }).build();
        this.server.start();
    }

    private int getInboundMessageSize() {
        String messageSize = System.getProperty(GRPC_MAX_INBOUND_MSG_SIZE_PROPERTY, String.valueOf(0xA00000L));
        return Integer.parseInt(messageSize);
    }

    private Channel getInternalChannel(ServerCall serverCall) {
        ServerStream serverStream = (ServerStream)ReflectUtils.getFieldValue((Object)serverCall, (String)"stream");
        return (Channel)ReflectUtils.getFieldValue((Object)serverStream, (String)"channel");
    }

    private void addServices(MutableHandlerRegistry handlerRegistry, ServerInterceptor ... serverInterceptor) {
        MethodDescriptor unaryPayloadMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)REQUEST_SERVICE_NAME, (String)REQUEST_METHOD_NAME)).setRequestMarshaller(ProtoUtils.marshaller((Message)Payload.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Payload.getDefaultInstance())).build();
        ServerCallHandler payloadHandler = ServerCalls.asyncUnaryCall((request, responseObserver) -> this.grpcCommonRequestAcceptor.request((Payload)request, (StreamObserver<Payload>)responseObserver));
        ServerServiceDefinition serviceDefOfUnaryPayload = ServerServiceDefinition.builder((String)REQUEST_SERVICE_NAME).addMethod(unaryPayloadMethod, payloadHandler).build();
        handlerRegistry.addService(ServerInterceptors.intercept((ServerServiceDefinition)serviceDefOfUnaryPayload, (ServerInterceptor[])serverInterceptor));
        ServerCallHandler biStreamHandler = ServerCalls.asyncBidiStreamingCall(responseObserver -> this.grpcBiStreamRequestAcceptor.requestBiStream((StreamObserver<Payload>)responseObserver));
        MethodDescriptor biStreamMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)REQUEST_BI_STREAM_SERVICE_NAME, (String)REQUEST_BI_STREAM_METHOD_NAME)).setRequestMarshaller(ProtoUtils.marshaller((Message)Payload.newBuilder().build())).setResponseMarshaller(ProtoUtils.marshaller((Message)Payload.getDefaultInstance())).build();
        ServerServiceDefinition serviceDefOfBiStream = ServerServiceDefinition.builder((String)REQUEST_BI_STREAM_SERVICE_NAME).addMethod(biStreamMethod, biStreamHandler).build();
        handlerRegistry.addService(ServerInterceptors.intercept((ServerServiceDefinition)serviceDefOfBiStream, (ServerInterceptor[])serverInterceptor));
    }

    @Override
    public void shutdownServer() {
        if (this.server != null) {
            this.server.shutdownNow();
        }
    }

    public abstract ThreadPoolExecutor getRpcExecutor();
}

