/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.grpc.auto.Payload;
import com.alibaba.nacos.api.grpc.auto.RequestGrpc;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.request.ServerCheckRequest;
import com.alibaba.nacos.api.remote.response.ErrorResponse;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.api.remote.response.ResponseCode;
import com.alibaba.nacos.api.remote.response.ServerCheckResponse;
import com.alibaba.nacos.common.remote.client.grpc.GrpcUtils;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.core.remote.RequestHandlerRegistry;
import com.alibaba.nacos.core.remote.grpc.BaseGrpcServer;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GrpcRequestAcceptor
extends RequestGrpc.RequestImplBase {
    @Autowired
    RequestHandlerRegistry requestHandlerRegistry;
    @Autowired
    private ConnectionManager connectionManager;

    private void traceIfNecessary(Payload grpcRequest, boolean receive) {
        String clientIp = grpcRequest.getMetadata().getClientIp();
        String connectionId = (String)BaseGrpcServer.CONTEXT_KEY_CONN_ID.get();
        try {
            if (this.connectionManager.traced(clientIp)) {
                Loggers.REMOTE_DIGEST.info("[{}]Payload {},meta={},body={}", new Object[]{connectionId, receive ? "receive" : "send", grpcRequest.getMetadata().toByteString().toStringUtf8(), grpcRequest.getBody().toByteString().toStringUtf8()});
            }
        }
        catch (Throwable throwable) {
            Loggers.REMOTE_DIGEST.error("[{}]Monitor request error,payload={},error={}", new Object[]{connectionId, clientIp, grpcRequest.toByteString().toStringUtf8()});
        }
    }

    public void request(Payload grpcRequest, StreamObserver<Payload> responseObserver) {
        Payload payloadResponse;
        this.traceIfNecessary(grpcRequest, true);
        String type = grpcRequest.getMetadata().getType();
        if (!ApplicationUtils.isStarted()) {
            Payload payloadResponse2 = GrpcUtils.convert((Response)this.buildErrorResponse(300, "Server is starting,please try later."));
            this.traceIfNecessary(payloadResponse2, false);
            responseObserver.onNext((Object)payloadResponse2);
            responseObserver.onCompleted();
            return;
        }
        if (ServerCheckRequest.class.getSimpleName().equals(type)) {
            Payload serverCheckResponseP = GrpcUtils.convert((Response)new ServerCheckResponse((String)BaseGrpcServer.CONTEXT_KEY_CONN_ID.get()));
            this.traceIfNecessary(serverCheckResponseP, false);
            responseObserver.onNext((Object)serverCheckResponseP);
            responseObserver.onCompleted();
            return;
        }
        RequestHandler requestHandler = this.requestHandlerRegistry.getByRequestType(type);
        if (requestHandler == null) {
            Loggers.REMOTE_DIGEST.warn(String.format("[%s] No handler for request type : %s :", "grpc", type));
            Payload payloadResponse3 = GrpcUtils.convert((Response)this.buildErrorResponse(302, "RequestHandler Not Found"));
            this.traceIfNecessary(payloadResponse3, false);
            responseObserver.onNext((Object)payloadResponse3);
            responseObserver.onCompleted();
            return;
        }
        String connectionId = (String)BaseGrpcServer.CONTEXT_KEY_CONN_ID.get();
        boolean requestValid = this.connectionManager.checkValid(connectionId);
        if (!requestValid) {
            Loggers.REMOTE_DIGEST.warn("[{}] Invalid connection Id ,connection [{}] is un registered ,", (Object)"grpc", (Object)connectionId);
            Payload payloadResponse4 = GrpcUtils.convert((Response)this.buildErrorResponse(301, "Connection is unregistered."));
            this.traceIfNecessary(payloadResponse4, false);
            responseObserver.onNext((Object)payloadResponse4);
            responseObserver.onCompleted();
            return;
        }
        Object parseObj = null;
        try {
            parseObj = GrpcUtils.parse((Payload)grpcRequest);
        }
        catch (Exception e) {
            Loggers.REMOTE_DIGEST.warn("[{}] Invalid request receive from connection [{}] ,error={}", new Object[]{"grpc", connectionId, e});
            Payload payloadResponse5 = GrpcUtils.convert((Response)this.buildErrorResponse(502, e.getMessage()));
            this.traceIfNecessary(payloadResponse5, false);
            responseObserver.onNext((Object)payloadResponse5);
            responseObserver.onCompleted();
            return;
        }
        if (parseObj == null) {
            Loggers.REMOTE_DIGEST.warn("[{}] Invalid request receive  ,parse request is null", (Object)connectionId);
            payloadResponse = GrpcUtils.convert((Response)this.buildErrorResponse(502, "Invalid request"));
            this.traceIfNecessary(payloadResponse, false);
            responseObserver.onNext((Object)payloadResponse);
            responseObserver.onCompleted();
        }
        if (!(parseObj instanceof Request)) {
            Loggers.REMOTE_DIGEST.warn("[{}] Invalid request receive  ,parsed payload is not a request,parseObj={}", (Object)connectionId, parseObj);
            payloadResponse = GrpcUtils.convert((Response)this.buildErrorResponse(502, "Invalid request"));
            this.traceIfNecessary(payloadResponse, false);
            responseObserver.onNext((Object)payloadResponse);
            responseObserver.onCompleted();
            return;
        }
        Request request = (Request)parseObj;
        try {
            Connection connection = this.connectionManager.getConnection((String)BaseGrpcServer.CONTEXT_KEY_CONN_ID.get());
            RequestMeta requestMeta = new RequestMeta();
            requestMeta.setClientIp(connection.getMetaInfo().getClientIp());
            requestMeta.setConnectionId((String)BaseGrpcServer.CONTEXT_KEY_CONN_ID.get());
            requestMeta.setClientVersion(connection.getMetaInfo().getVersion());
            requestMeta.setLabels(connection.getMetaInfo().getLabels());
            this.connectionManager.refreshActiveTime(requestMeta.getConnectionId());
            Response response = requestHandler.handleRequest(request, requestMeta);
            Payload payloadResponse6 = GrpcUtils.convert((Response)response);
            this.traceIfNecessary(payloadResponse6, false);
            responseObserver.onNext((Object)payloadResponse6);
            responseObserver.onCompleted();
        }
        catch (Throwable e) {
            Loggers.REMOTE_DIGEST.error("[{}] Fail to handle request from connection [{}] ,error message :{}", new Object[]{"grpc", connectionId, e});
            Payload payloadResponse7 = GrpcUtils.convert((Response)this.buildErrorResponse(e instanceof NacosException ? ((NacosException)e).getErrCode() : ResponseCode.FAIL.getCode(), e.getMessage()));
            this.traceIfNecessary(payloadResponse7, false);
            responseObserver.onNext((Object)payloadResponse7);
            responseObserver.onCompleted();
        }
    }

    private Response buildErrorResponse(int errorCode, String msg) {
        ErrorResponse response = new ErrorResponse();
        response.setErrorInfo(errorCode, msg);
        return response;
    }
}

