/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck.v2.processor;

import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.healthcheck.extend.HealthCheckExtendProvider;
import com.alibaba.nacos.naming.healthcheck.v2.HealthCheckTaskV2;
import com.alibaba.nacos.naming.healthcheck.v2.processor.HealthCheckProcessorV2;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="healthCheckDelegateV2")
public class HealthCheckProcessorV2Delegate
implements HealthCheckProcessorV2 {
    private final Map<String, HealthCheckProcessorV2> healthCheckProcessorMap = new HashMap<String, HealthCheckProcessorV2>();

    public HealthCheckProcessorV2Delegate(HealthCheckExtendProvider provider) {
        provider.init();
    }

    @Autowired
    public void addProcessor(Collection<HealthCheckProcessorV2> processors) {
        this.healthCheckProcessorMap.putAll(processors.stream().filter(processor -> processor.getType() != null).collect(Collectors.toMap(HealthCheckProcessorV2::getType, processor -> processor)));
    }

    @Override
    public void process(HealthCheckTaskV2 task, Service service, ClusterMetadata metadata) {
        String type = metadata.getHealthyCheckType();
        HealthCheckProcessorV2 processor = this.healthCheckProcessorMap.get(type);
        if (processor == null) {
            processor = this.healthCheckProcessorMap.get("NONE");
        }
        processor.process(task, service, metadata);
    }

    @Override
    public String getType() {
        return null;
    }
}

