/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v2.executor;

import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.api.remote.PushCallBack;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.push.UdpPushService;
import com.alibaba.nacos.naming.push.v2.PushDataWrapper;
import com.alibaba.nacos.naming.push.v2.executor.PushExecutor;
import com.alibaba.nacos.naming.utils.ServiceUtil;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class PushExecutorUdpImpl
implements PushExecutor {
    private static final String UDP_PUSH_DATA_FOR_V1 = "udpPushDataForV1";
    private final UdpPushService pushService;

    public PushExecutorUdpImpl(UdpPushService pushService) {
        this.pushService = pushService;
    }

    @Override
    public void doPush(String clientId, Subscriber subscriber, PushDataWrapper data) {
        this.pushService.pushDataWithoutCallback(subscriber, this.handleClusterData(this.replaceServiceInfoName(data), subscriber));
    }

    @Override
    public void doPushWithCallback(String clientId, Subscriber subscriber, PushDataWrapper data, PushCallBack callBack) {
        this.pushService.pushDataWithCallback(subscriber, this.handleClusterData(this.replaceServiceInfoName(data), subscriber), callBack);
    }

    private ServiceInfo replaceServiceInfoName(PushDataWrapper originalData) {
        Optional original = originalData.getProcessedPushData(UDP_PUSH_DATA_FOR_V1);
        if (original.isPresent()) {
            return (ServiceInfo)original.get();
        }
        ServiceInfo serviceInfo = this.getServiceInfo(originalData);
        ServiceInfo result = new ServiceInfo();
        result.setName(NamingUtils.getGroupedName((String)serviceInfo.getName(), (String)serviceInfo.getGroupName()));
        result.setClusters(serviceInfo.getClusters());
        result.setHosts(serviceInfo.getHosts());
        result.setLastRefTime(serviceInfo.getLastRefTime());
        result.setCacheMillis(serviceInfo.getCacheMillis());
        originalData.addProcessedPushData(UDP_PUSH_DATA_FOR_V1, result);
        return result;
    }

    private ServiceInfo getServiceInfo(PushDataWrapper data) {
        return ServiceUtil.selectInstancesWithHealthyProtection(data.getOriginalData(), data.getServiceMetadata(), false, true);
    }

    @Deprecated
    private ServiceInfo handleClusterData(ServiceInfo data, Subscriber subscriber) {
        return StringUtils.isBlank((CharSequence)subscriber.getCluster()) ? data : ServiceUtil.selectInstances(data, subscriber.getCluster());
    }
}

