/*
 * Decompiled with CFR 0.152.
 */
package com.spring4all.swagger;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.spring4all.swagger.PathSelectors;
import com.spring4all.swagger.SwaggerAuthorizationConfiguration;
import com.spring4all.swagger.SwaggerProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.ParameterType;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

@Configuration
@EnableConfigurationProperties(value={SwaggerProperties.class})
public class DocketConfiguration
implements BeanFactoryAware {
    private BeanFactory beanFactory;
    @Autowired
    private SwaggerProperties swaggerProperties;
    @Autowired
    private SwaggerAuthorizationConfiguration authConfiguration;
    private static final String BEAN_NAME = "spring-boot-starter-swagger-";

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Bean
    public void createSpringFoxRestApi() {
        BeanDefinitionRegistry beanRegistry = (BeanDefinitionRegistry)this.beanFactory;
        if (this.swaggerProperties.getDocket().size() == 0) {
            String beanName = "spring-boot-starter-swagger-default";
            GenericBeanDefinition beanDefinition4Group = new GenericBeanDefinition();
            beanDefinition4Group.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)DocumentationType.OAS_30);
            beanDefinition4Group.setBeanClassName(Docket.class.getName());
            beanDefinition4Group.setRole(1);
            beanRegistry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition4Group);
            Docket docket4Group = (Docket)this.beanFactory.getBean(beanName);
            ApiInfo apiInfo = this.apiInfo(this.swaggerProperties);
            docket4Group.host(this.swaggerProperties.getHost()).apiInfo(apiInfo).globalRequestParameters(this.assemblyRequestParameters(this.swaggerProperties.getGlobalOperationParameters(), new ArrayList<SwaggerProperties.GlobalOperationParameter>())).securityContexts(Collections.singletonList(this.authConfiguration.securityContext())).securitySchemes(this.authConfiguration.getSecuritySchemes()).select().apis(RequestHandlerSelectors.basePackage((String)this.swaggerProperties.getBasePackage())).paths(this.paths(this.swaggerProperties.getBasePath(), this.swaggerProperties.getExcludePath())).build();
            return;
        }
        for (Map.Entry<String, SwaggerProperties.DocketInfo> entry : this.swaggerProperties.getDocket().entrySet()) {
            String groupName = entry.getKey();
            SwaggerProperties.DocketInfo docketInfo = entry.getValue();
            String beanName = BEAN_NAME + groupName;
            ApiInfo apiInfo = new ApiInfoBuilder().title(docketInfo.getTitle().isEmpty() ? this.swaggerProperties.getTitle() : docketInfo.getTitle()).description(docketInfo.getDescription().isEmpty() ? this.swaggerProperties.getDescription() : docketInfo.getDescription()).version(docketInfo.getVersion().isEmpty() ? this.swaggerProperties.getVersion() : docketInfo.getVersion()).license(docketInfo.getLicense().isEmpty() ? this.swaggerProperties.getLicense() : docketInfo.getLicense()).licenseUrl(docketInfo.getLicenseUrl().isEmpty() ? this.swaggerProperties.getLicenseUrl() : docketInfo.getLicenseUrl()).contact(new Contact(docketInfo.getContact().getName().isEmpty() ? this.swaggerProperties.getContact().getName() : docketInfo.getContact().getName(), docketInfo.getContact().getUrl().isEmpty() ? this.swaggerProperties.getContact().getUrl() : docketInfo.getContact().getUrl(), docketInfo.getContact().getEmail().isEmpty() ? this.swaggerProperties.getContact().getEmail() : docketInfo.getContact().getEmail())).termsOfServiceUrl(docketInfo.getTermsOfServiceUrl().isEmpty() ? this.swaggerProperties.getTermsOfServiceUrl() : docketInfo.getTermsOfServiceUrl()).build();
            if (docketInfo.getBasePath().isEmpty()) {
                docketInfo.getBasePath().add("/**");
            }
            ArrayList<com.google.common.base.Predicate<String>> basePath = new ArrayList<com.google.common.base.Predicate<String>>();
            for (String string : docketInfo.getBasePath()) {
                basePath.add(PathSelectors.ant(string));
            }
            ArrayList<com.google.common.base.Predicate<String>> excludePath = new ArrayList<com.google.common.base.Predicate<String>>();
            for (String path3 : docketInfo.getExcludePath()) {
                excludePath.add(PathSelectors.ant(path3));
            }
            GenericBeanDefinition genericBeanDefinition = new GenericBeanDefinition();
            genericBeanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)DocumentationType.OAS_30);
            genericBeanDefinition.setBeanClassName(Docket.class.getName());
            genericBeanDefinition.setRole(1);
            beanRegistry.registerBeanDefinition(beanName, (BeanDefinition)genericBeanDefinition);
            Docket docket4Group = (Docket)this.beanFactory.getBean(beanName);
            docket4Group.groupName(groupName).host(docketInfo.getBasePackage()).apiInfo(apiInfo).globalRequestParameters(this.assemblyRequestParameters(this.swaggerProperties.getGlobalOperationParameters(), docketInfo.getGlobalOperationParameters())).securityContexts(Collections.singletonList(this.authConfiguration.securityContext())).securitySchemes(this.authConfiguration.getSecuritySchemes()).select().apis(RequestHandlerSelectors.basePackage((String)docketInfo.getBasePackage())).paths(this.paths(docketInfo.getBasePath(), docketInfo.getExcludePath())).build();
        }
    }

    private List<RequestParameter> getRequestParameters(List<SwaggerProperties.GlobalOperationParameter> properties) {
        return properties.stream().map(param -> new RequestParameterBuilder().name(param.getName()).description(param.getDescription()).in(ParameterType.from((String)param.getParameterType())).required(param.getRequired()).query(q -> q.defaultValue(param.getType())).query(q -> q.model(m -> m.scalarModel(!ScalarType.from((String)param.getType(), (String)param.getFormat()).isPresent() ? ScalarType.STRING : (ScalarType)ScalarType.from((String)param.getType(), (String)param.getFormat()).get()))).build()).collect(Collectors.toList());
    }

    private List<RequestParameter> assemblyRequestParameters(List<SwaggerProperties.GlobalOperationParameter> globalRequestParameters, List<SwaggerProperties.GlobalOperationParameter> groupRequestParameters) {
        if (Objects.isNull(groupRequestParameters) || groupRequestParameters.isEmpty()) {
            return this.getRequestParameters(globalRequestParameters);
        }
        Set paramNames = groupRequestParameters.stream().map(SwaggerProperties.GlobalOperationParameter::getName).collect(Collectors.toSet());
        ArrayList requestParameters = Lists.newArrayList();
        if (Objects.nonNull(globalRequestParameters)) {
            for (SwaggerProperties.GlobalOperationParameter parameter : globalRequestParameters) {
                if (paramNames.contains(parameter.getName())) continue;
                requestParameters.add(parameter);
            }
        }
        requestParameters.addAll(groupRequestParameters);
        return this.getRequestParameters(requestParameters);
    }

    private Predicate paths(List<String> basePath, List<String> excludePath) {
        if (basePath.isEmpty()) {
            basePath.add("/**");
        }
        ArrayList<com.google.common.base.Predicate<String>> basePathList = new ArrayList<com.google.common.base.Predicate<String>>();
        for (String path : basePath) {
            basePathList.add(PathSelectors.ant(path));
        }
        ArrayList<com.google.common.base.Predicate<String>> excludePathList = new ArrayList<com.google.common.base.Predicate<String>>();
        for (String path : excludePath) {
            excludePathList.add(PathSelectors.ant(path));
        }
        return Predicates.and((com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.or(excludePathList)), (com.google.common.base.Predicate)Predicates.or(basePathList));
    }

    private ApiInfo apiInfo(SwaggerProperties swaggerProperties) {
        return new ApiInfoBuilder().title(swaggerProperties.getTitle()).description(swaggerProperties.getDescription()).version(swaggerProperties.getVersion()).license(swaggerProperties.getLicense()).licenseUrl(swaggerProperties.getLicenseUrl()).contact(new Contact(swaggerProperties.getContact().getName(), swaggerProperties.getContact().getUrl(), swaggerProperties.getContact().getEmail())).termsOfServiceUrl(swaggerProperties.getTermsOfServiceUrl()).build();
    }
}

