/*
 * Decompiled with CFR 0.152.
 */
package com.spring4all.swagger;

import com.spring4all.swagger.SwaggerAuthorizationProperties;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.BasicAuth;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.swagger.web.ApiKeyVehicle;

@Configuration
@EnableConfigurationProperties(value={SwaggerAuthorizationProperties.class})
public class SwaggerAuthorizationConfiguration {
    public SwaggerAuthorizationProperties properties;

    public SwaggerAuthorizationConfiguration(SwaggerAuthorizationProperties properties) {
        this.properties = properties;
    }

    public SecurityContext securityContext() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        List<SecurityReference> defaultAuth = Collections.singletonList(SecurityReference.builder().reference(this.properties.getName()).scopes(authorizationScopes).build());
        return SecurityContext.builder().securityReferences(defaultAuth).forPaths(PathSelectors.regex((String)this.properties.getAuthRegex())).build();
    }

    public List<SecurityScheme> getSecuritySchemes() {
        if ("BasicAuth".equalsIgnoreCase(this.getType())) {
            return Collections.singletonList(this.basicAuth());
        }
        if (!"None".equalsIgnoreCase(this.getType())) {
            return Collections.singletonList(this.apiKey());
        }
        return null;
    }

    private ApiKey apiKey() {
        return new ApiKey(this.properties.getName(), this.properties.getKeyName(), ApiKeyVehicle.HEADER.getValue());
    }

    private BasicAuth basicAuth() {
        return new BasicAuth(this.properties.getName());
    }

    private String getType() {
        return this.properties.getType();
    }
}

