/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.DeletedSKU;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Inventory;
import com.stripe.model.MetadataStore;
import com.stripe.model.PackageDimensions;
import com.stripe.model.Product;
import com.stripe.model.SKUCollection;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class SKU
extends APIResource
implements HasId,
MetadataStore<SKU> {
    String id;
    String object;
    Boolean active;
    Map<String, String> attributes;
    Long created;
    String currency;
    String image;
    Inventory inventory;
    Boolean livemode;
    Map<String, String> metadata;
    PackageDimensions packageDimensions;
    Integer price;
    ExpandableField<Product> product;
    Long updated;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public PackageDimensions getPackageDimensions() {
        return this.packageDimensions;
    }

    public void setPackageDimensions(PackageDimensions packageDimensions) {
        this.packageDimensions = packageDimensions;
    }

    public Integer getPrice() {
        return this.price;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public String getProduct() {
        if (this.product == null) {
            return null;
        }
        return this.product.getId();
    }

    public void setProduct(String productID) {
        this.product = SKU.setExpandableFieldID(productID, this.product);
    }

    public Product getProductObject() {
        if (this.product == null) {
            return null;
        }
        return this.product.getExpanded();
    }

    public void setProductObject(Product product) {
        this.product = new ExpandableField<Product>(product.getId(), product);
    }

    public Long getUpdated() {
        return this.updated;
    }

    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    public static SKU create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.create(params, null);
    }

    public static SKU retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.retrieve(id, null);
    }

    public SKU update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public static SKU create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.request(APIResource.RequestMethod.POST, SKU.classURL(SKU.class), params, SKU.class, options);
    }

    public static SKU retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.request(APIResource.RequestMethod.GET, SKU.instanceURL(SKU.class, id), null, SKU.class, options);
    }

    public static SKU retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.request(APIResource.RequestMethod.GET, SKU.instanceURL(SKU.class, id), params, SKU.class, options);
    }

    public DeletedSKU delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(null);
    }

    public DeletedSKU delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.request(APIResource.RequestMethod.DELETE, SKU.instanceURL(SKU.class, this.id), null, DeletedSKU.class, options);
    }

    public static SKUCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.list(params, null);
    }

    public static SKUCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.requestCollection(SKU.classURL(SKU.class), params, SKUCollection.class, options);
    }

    @Deprecated
    public static SKUCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.list(params, null);
    }

    @Deprecated
    public static SKUCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.list(params, options);
    }

    public SKU update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.request(APIResource.RequestMethod.POST, SKU.instanceURL(SKU.class, this.id), params, SKU.class, options);
    }
}

