/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.stripe.Stripe;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionDeserializer;
import com.stripe.model.ChargeRefundCollection;
import com.stripe.model.ChargeRefundCollectionDeserializer;
import com.stripe.model.Dispute;
import com.stripe.model.DisputeDataDeserializer;
import com.stripe.model.EphemeralKey;
import com.stripe.model.EphemeralKeyDeserializer;
import com.stripe.model.EventData;
import com.stripe.model.EventDataDeserializer;
import com.stripe.model.EventRequest;
import com.stripe.model.EventRequestDeserializer;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExpandableFieldDeserializer;
import com.stripe.model.ExternalAccountTypeAdapterFactory;
import com.stripe.model.FeeRefundCollection;
import com.stripe.model.FeeRefundCollectionDeserializer;
import com.stripe.model.HasId;
import com.stripe.model.OrderItem;
import com.stripe.model.OrderItemDeserializer;
import com.stripe.model.Source;
import com.stripe.model.SourceTransaction;
import com.stripe.model.SourceTypeDataDeserializer;
import com.stripe.model.StripeCollectionInterface;
import com.stripe.model.StripeObject;
import com.stripe.model.StripeRawJsonObject;
import com.stripe.model.StripeRawJsonObjectDeserializer;
import com.stripe.net.LiveStripeResponseGetter;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public abstract class APIResource
extends StripeObject {
    private static StripeResponseGetter stripeResponseGetter = new LiveStripeResponseGetter();
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(EventData.class, (Object)new EventDataDeserializer()).registerTypeAdapter(EventRequest.class, (Object)new EventRequestDeserializer()).registerTypeAdapter(ChargeRefundCollection.class, (Object)new ChargeRefundCollectionDeserializer()).registerTypeAdapter(FeeRefundCollection.class, (Object)new FeeRefundCollectionDeserializer()).registerTypeAdapter(StripeRawJsonObject.class, (Object)new StripeRawJsonObjectDeserializer()).registerTypeAdapter(BalanceTransaction.class, (Object)new BalanceTransactionDeserializer()).registerTypeAdapter(Dispute.class, (Object)new DisputeDataDeserializer()).registerTypeAdapter(Source.class, new SourceTypeDataDeserializer()).registerTypeAdapter(SourceTransaction.class, new SourceTypeDataDeserializer()).registerTypeAdapter(OrderItem.class, (Object)new OrderItemDeserializer()).registerTypeAdapter(ExpandableField.class, (Object)new ExpandableFieldDeserializer()).registerTypeAdapter(EphemeralKey.class, (Object)new EphemeralKeyDeserializer()).registerTypeAdapterFactory((TypeAdapterFactory)new ExternalAccountTypeAdapterFactory()).create();
    public static final String CHARSET = "UTF-8";

    public static void setStripeResponseGetter(StripeResponseGetter srg) {
        stripeResponseGetter = srg;
    }

    private static String className(Class<?> clazz) {
        String className = clazz.getSimpleName().toLowerCase().replace("$", " ");
        if (className.equals("applicationfee")) {
            return "application_fee";
        }
        if (className.equals("fileupload")) {
            return "file";
        }
        if (className.equals("bitcoinreceiver")) {
            return "bitcoin_receiver";
        }
        if (className.equals("countryspec")) {
            return "country_spec";
        }
        if (className.equals("orderreturn")) {
            return "order_return";
        }
        if (className.equals("threedsecure")) {
            return "three_d_secure";
        }
        if (className.equals("applepaydomain")) {
            return "apple_pay_domain";
        }
        if (className.equals("subscriptionitem")) {
            return "subscription_item";
        }
        if (className.equals("ephemeralkey")) {
            return "ephemeral_key";
        }
        if (className.equals("sourcetransaction")) {
            return "source_transaction";
        }
        return className;
    }

    protected static String singleClassURL(Class<?> clazz) {
        return APIResource.singleClassURL(clazz, Stripe.getApiBase());
    }

    protected static String singleClassURL(Class<?> clazz, String apiBase) {
        return String.format("%s/v1/%s", apiBase, APIResource.className(clazz));
    }

    protected static String classURL(Class<?> clazz) {
        return APIResource.classURL(clazz, Stripe.getApiBase());
    }

    protected static String classURL(Class<?> clazz, String apiBase) {
        return String.format("%ss", APIResource.singleClassURL(clazz, apiBase));
    }

    protected static String instanceURL(Class<?> clazz, String id) throws InvalidRequestException {
        return APIResource.instanceURL(clazz, id, Stripe.getApiBase());
    }

    protected static String instanceURL(Class<?> clazz, String id, String apiBase) throws InvalidRequestException {
        try {
            return String.format("%s/%s", APIResource.classURL(clazz, apiBase), APIResource.urlEncode(id));
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@stripe.com for assistance.", null, null, 0, e);
        }
    }

    public static String urlEncode(String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str, CHARSET);
    }

    public static <T> T multipartRequest(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return stripeResponseGetter.request(method, url, params, clazz, RequestType.MULTIPART, options);
    }

    public static <T> T request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return stripeResponseGetter.request(method, url, params, clazz, RequestType.NORMAL, options);
    }

    public static <T extends StripeCollectionInterface> T requestCollection(String url, Map<String, Object> params, Class<T> clazz, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        StripeCollectionInterface collection = (StripeCollectionInterface)APIResource.request(RequestMethod.GET, url, params, clazz, options);
        if (collection != null) {
            collection.setRequestOptions(options);
            collection.setRequestParams(params);
        }
        return (T)collection;
    }

    public static <T extends HasId> ExpandableField<T> setExpandableFieldID(String newId, ExpandableField<T> currentObject) {
        if (currentObject == null || currentObject.isExpanded() && currentObject.getId() != newId) {
            return new ExpandableField<Object>(newId, null);
        }
        return new ExpandableField<T>(newId, currentObject.getExpanded());
    }

    public static enum RequestType {
        NORMAL,
        MULTIPART;

    }

    public static enum RequestMethod {
        GET,
        POST,
        DELETE;

    }
}

