/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cfw.v20190904.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreateBlockIgnoreRuleListRequest extends AbstractModel {

    /**
    * 规则列表
    */
    @SerializedName("Rules")
    @Expose
    private IntrusionDefenseRule [] Rules;

    /**
    * 规则类型，1封禁，2放通，不支持域名封禁
    */
    @SerializedName("RuleType")
    @Expose
    private Long RuleType;

    /**
    * 是否覆盖重复数据，1覆盖，非1不覆盖，跳过重复数据
    */
    @SerializedName("CoverDuplicate")
    @Expose
    private Long CoverDuplicate;

    /**
     * Get 规则列表 
     * @return Rules 规则列表
     */
    public IntrusionDefenseRule [] getRules() {
        return this.Rules;
    }

    /**
     * Set 规则列表
     * @param Rules 规则列表
     */
    public void setRules(IntrusionDefenseRule [] Rules) {
        this.Rules = Rules;
    }

    /**
     * Get 规则类型，1封禁，2放通，不支持域名封禁 
     * @return RuleType 规则类型，1封禁，2放通，不支持域名封禁
     */
    public Long getRuleType() {
        return this.RuleType;
    }

    /**
     * Set 规则类型，1封禁，2放通，不支持域名封禁
     * @param RuleType 规则类型，1封禁，2放通，不支持域名封禁
     */
    public void setRuleType(Long RuleType) {
        this.RuleType = RuleType;
    }

    /**
     * Get 是否覆盖重复数据，1覆盖，非1不覆盖，跳过重复数据 
     * @return CoverDuplicate 是否覆盖重复数据，1覆盖，非1不覆盖，跳过重复数据
     */
    public Long getCoverDuplicate() {
        return this.CoverDuplicate;
    }

    /**
     * Set 是否覆盖重复数据，1覆盖，非1不覆盖，跳过重复数据
     * @param CoverDuplicate 是否覆盖重复数据，1覆盖，非1不覆盖，跳过重复数据
     */
    public void setCoverDuplicate(Long CoverDuplicate) {
        this.CoverDuplicate = CoverDuplicate;
    }

    public CreateBlockIgnoreRuleListRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreateBlockIgnoreRuleListRequest(CreateBlockIgnoreRuleListRequest source) {
        if (source.Rules != null) {
            this.Rules = new IntrusionDefenseRule[source.Rules.length];
            for (int i = 0; i < source.Rules.length; i++) {
                this.Rules[i] = new IntrusionDefenseRule(source.Rules[i]);
            }
        }
        if (source.RuleType != null) {
            this.RuleType = new Long(source.RuleType);
        }
        if (source.CoverDuplicate != null) {
            this.CoverDuplicate = new Long(source.CoverDuplicate);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Rules.", this.Rules);
        this.setParamSimple(map, prefix + "RuleType", this.RuleType);
        this.setParamSimple(map, prefix + "CoverDuplicate", this.CoverDuplicate);

    }
}

