/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class MalwareInfo extends AbstractModel {

    /**
    * 病毒名称
    */
    @SerializedName("VirusName")
    @Expose
    private String VirusName;

    /**
    * 文件大小
    */
    @SerializedName("FileSize")
    @Expose
    private Long FileSize;

    /**
    * 文件MD5
    */
    @SerializedName("MD5")
    @Expose
    private String MD5;

    /**
    * 文件地址
    */
    @SerializedName("FilePath")
    @Expose
    private String FilePath;

    /**
    * 首次运行时间
    */
    @SerializedName("FileCreateTime")
    @Expose
    private String FileCreateTime;

    /**
    * 最近一次运行时间
    */
    @SerializedName("FileModifierTime")
    @Expose
    private String FileModifierTime;

    /**
    * 危害描述
    */
    @SerializedName("HarmDescribe")
    @Expose
    private String HarmDescribe;

    /**
    * 建议方案
    */
    @SerializedName("SuggestScheme")
    @Expose
    private String SuggestScheme;

    /**
    * 服务器名称
    */
    @SerializedName("ServersName")
    @Expose
    private String ServersName;

    /**
    * 服务器IP
    */
    @SerializedName("HostIp")
    @Expose
    private String HostIp;

    /**
    * 进程名称
    */
    @SerializedName("ProcessName")
    @Expose
    private String ProcessName;

    /**
    * 进程ID
    */
    @SerializedName("ProcessID")
    @Expose
    private String ProcessID;

    /**
    * 标签特性
    */
    @SerializedName("Tags")
    @Expose
    private String [] Tags;

    /**
    * 影响广度 // 暂时不提供
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Breadth")
    @Expose
    private String Breadth;

    /**
    * 查询热度 // 暂时不提供
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Heat")
    @Expose
    private String Heat;

    /**
    * 唯一ID
    */
    @SerializedName("Id")
    @Expose
    private Long Id;

    /**
    * 文件名称
    */
    @SerializedName("FileName")
    @Expose
    private String FileName;

    /**
    * 首次发现时间
    */
    @SerializedName("CreateTime")
    @Expose
    private String CreateTime;

    /**
    * 最近扫描时间
    */
    @SerializedName("LatestScanTime")
    @Expose
    private String LatestScanTime;

    /**
    * 参考链接
    */
    @SerializedName("Reference")
    @Expose
    private String Reference;

    /**
    * 外网ip
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("MachineWanIp")
    @Expose
    private String MachineWanIp;

    /**
    * 进程树 json  pid:进程id，exe:文件路径 ，account:进程所属用组和用户 ,cmdline:执行命令，ssh_service: SSH服务ip, ssh_soure:登录源
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("PsTree")
    @Expose
    private String PsTree;

    /**
    * 主机在线状态 OFFLINE  ONLINE
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("MachineStatus")
    @Expose
    private String MachineStatus;

    /**
    * 状态；4-:待处理，5-已信任，6-已隔离
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Status")
    @Expose
    private Long Status;

    /**
    * 风险等级 0提示、1低、2中、3高、4严重
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Level")
    @Expose
    private Long Level;

    /**
    * 木马检测平台用,分割 1云查杀引擎、2TAV、3binaryAi、4异常行为、5威胁情报
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("CheckPlatform")
    @Expose
    private String CheckPlatform;

    /**
    * 主机uuid
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Uuid")
    @Expose
    private String Uuid;

    /**
    * 最近修改时间
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("ModifyTime")
    @Expose
    private String ModifyTime;

    /**
    * 最近访问时间
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("StrFileAccessTime")
    @Expose
    private String StrFileAccessTime;

    /**
    * 附加信息
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("MachineExtraInfo")
    @Expose
    private MachineExtraInfo MachineExtraInfo;

    /**
     * Get 病毒名称 
     * @return VirusName 病毒名称
     */
    public String getVirusName() {
        return this.VirusName;
    }

    /**
     * Set 病毒名称
     * @param VirusName 病毒名称
     */
    public void setVirusName(String VirusName) {
        this.VirusName = VirusName;
    }

    /**
     * Get 文件大小 
     * @return FileSize 文件大小
     */
    public Long getFileSize() {
        return this.FileSize;
    }

    /**
     * Set 文件大小
     * @param FileSize 文件大小
     */
    public void setFileSize(Long FileSize) {
        this.FileSize = FileSize;
    }

    /**
     * Get 文件MD5 
     * @return MD5 文件MD5
     */
    public String getMD5() {
        return this.MD5;
    }

    /**
     * Set 文件MD5
     * @param MD5 文件MD5
     */
    public void setMD5(String MD5) {
        this.MD5 = MD5;
    }

    /**
     * Get 文件地址 
     * @return FilePath 文件地址
     */
    public String getFilePath() {
        return this.FilePath;
    }

    /**
     * Set 文件地址
     * @param FilePath 文件地址
     */
    public void setFilePath(String FilePath) {
        this.FilePath = FilePath;
    }

    /**
     * Get 首次运行时间 
     * @return FileCreateTime 首次运行时间
     */
    public String getFileCreateTime() {
        return this.FileCreateTime;
    }

    /**
     * Set 首次运行时间
     * @param FileCreateTime 首次运行时间
     */
    public void setFileCreateTime(String FileCreateTime) {
        this.FileCreateTime = FileCreateTime;
    }

    /**
     * Get 最近一次运行时间 
     * @return FileModifierTime 最近一次运行时间
     */
    public String getFileModifierTime() {
        return this.FileModifierTime;
    }

    /**
     * Set 最近一次运行时间
     * @param FileModifierTime 最近一次运行时间
     */
    public void setFileModifierTime(String FileModifierTime) {
        this.FileModifierTime = FileModifierTime;
    }

    /**
     * Get 危害描述 
     * @return HarmDescribe 危害描述
     */
    public String getHarmDescribe() {
        return this.HarmDescribe;
    }

    /**
     * Set 危害描述
     * @param HarmDescribe 危害描述
     */
    public void setHarmDescribe(String HarmDescribe) {
        this.HarmDescribe = HarmDescribe;
    }

    /**
     * Get 建议方案 
     * @return SuggestScheme 建议方案
     */
    public String getSuggestScheme() {
        return this.SuggestScheme;
    }

    /**
     * Set 建议方案
     * @param SuggestScheme 建议方案
     */
    public void setSuggestScheme(String SuggestScheme) {
        this.SuggestScheme = SuggestScheme;
    }

    /**
     * Get 服务器名称 
     * @return ServersName 服务器名称
     */
    public String getServersName() {
        return this.ServersName;
    }

    /**
     * Set 服务器名称
     * @param ServersName 服务器名称
     */
    public void setServersName(String ServersName) {
        this.ServersName = ServersName;
    }

    /**
     * Get 服务器IP 
     * @return HostIp 服务器IP
     */
    public String getHostIp() {
        return this.HostIp;
    }

    /**
     * Set 服务器IP
     * @param HostIp 服务器IP
     */
    public void setHostIp(String HostIp) {
        this.HostIp = HostIp;
    }

    /**
     * Get 进程名称 
     * @return ProcessName 进程名称
     */
    public String getProcessName() {
        return this.ProcessName;
    }

    /**
     * Set 进程名称
     * @param ProcessName 进程名称
     */
    public void setProcessName(String ProcessName) {
        this.ProcessName = ProcessName;
    }

    /**
     * Get 进程ID 
     * @return ProcessID 进程ID
     */
    public String getProcessID() {
        return this.ProcessID;
    }

    /**
     * Set 进程ID
     * @param ProcessID 进程ID
     */
    public void setProcessID(String ProcessID) {
        this.ProcessID = ProcessID;
    }

    /**
     * Get 标签特性 
     * @return Tags 标签特性
     */
    public String [] getTags() {
        return this.Tags;
    }

    /**
     * Set 标签特性
     * @param Tags 标签特性
     */
    public void setTags(String [] Tags) {
        this.Tags = Tags;
    }

    /**
     * Get 影响广度 // 暂时不提供
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Breadth 影响广度 // 暂时不提供
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getBreadth() {
        return this.Breadth;
    }

    /**
     * Set 影响广度 // 暂时不提供
注意：此字段可能返回 null，表示取不到有效值。
     * @param Breadth 影响广度 // 暂时不提供
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setBreadth(String Breadth) {
        this.Breadth = Breadth;
    }

    /**
     * Get 查询热度 // 暂时不提供
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Heat 查询热度 // 暂时不提供
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getHeat() {
        return this.Heat;
    }

    /**
     * Set 查询热度 // 暂时不提供
注意：此字段可能返回 null，表示取不到有效值。
     * @param Heat 查询热度 // 暂时不提供
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setHeat(String Heat) {
        this.Heat = Heat;
    }

    /**
     * Get 唯一ID 
     * @return Id 唯一ID
     */
    public Long getId() {
        return this.Id;
    }

    /**
     * Set 唯一ID
     * @param Id 唯一ID
     */
    public void setId(Long Id) {
        this.Id = Id;
    }

    /**
     * Get 文件名称 
     * @return FileName 文件名称
     */
    public String getFileName() {
        return this.FileName;
    }

    /**
     * Set 文件名称
     * @param FileName 文件名称
     */
    public void setFileName(String FileName) {
        this.FileName = FileName;
    }

    /**
     * Get 首次发现时间 
     * @return CreateTime 首次发现时间
     */
    public String getCreateTime() {
        return this.CreateTime;
    }

    /**
     * Set 首次发现时间
     * @param CreateTime 首次发现时间
     */
    public void setCreateTime(String CreateTime) {
        this.CreateTime = CreateTime;
    }

    /**
     * Get 最近扫描时间 
     * @return LatestScanTime 最近扫描时间
     */
    public String getLatestScanTime() {
        return this.LatestScanTime;
    }

    /**
     * Set 最近扫描时间
     * @param LatestScanTime 最近扫描时间
     */
    public void setLatestScanTime(String LatestScanTime) {
        this.LatestScanTime = LatestScanTime;
    }

    /**
     * Get 参考链接 
     * @return Reference 参考链接
     */
    public String getReference() {
        return this.Reference;
    }

    /**
     * Set 参考链接
     * @param Reference 参考链接
     */
    public void setReference(String Reference) {
        this.Reference = Reference;
    }

    /**
     * Get 外网ip
注意：此字段可能返回 null，表示取不到有效值。 
     * @return MachineWanIp 外网ip
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getMachineWanIp() {
        return this.MachineWanIp;
    }

    /**
     * Set 外网ip
注意：此字段可能返回 null，表示取不到有效值。
     * @param MachineWanIp 外网ip
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setMachineWanIp(String MachineWanIp) {
        this.MachineWanIp = MachineWanIp;
    }

    /**
     * Get 进程树 json  pid:进程id，exe:文件路径 ，account:进程所属用组和用户 ,cmdline:执行命令，ssh_service: SSH服务ip, ssh_soure:登录源
注意：此字段可能返回 null，表示取不到有效值。 
     * @return PsTree 进程树 json  pid:进程id，exe:文件路径 ，account:进程所属用组和用户 ,cmdline:执行命令，ssh_service: SSH服务ip, ssh_soure:登录源
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getPsTree() {
        return this.PsTree;
    }

    /**
     * Set 进程树 json  pid:进程id，exe:文件路径 ，account:进程所属用组和用户 ,cmdline:执行命令，ssh_service: SSH服务ip, ssh_soure:登录源
注意：此字段可能返回 null，表示取不到有效值。
     * @param PsTree 进程树 json  pid:进程id，exe:文件路径 ，account:进程所属用组和用户 ,cmdline:执行命令，ssh_service: SSH服务ip, ssh_soure:登录源
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setPsTree(String PsTree) {
        this.PsTree = PsTree;
    }

    /**
     * Get 主机在线状态 OFFLINE  ONLINE
注意：此字段可能返回 null，表示取不到有效值。 
     * @return MachineStatus 主机在线状态 OFFLINE  ONLINE
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getMachineStatus() {
        return this.MachineStatus;
    }

    /**
     * Set 主机在线状态 OFFLINE  ONLINE
注意：此字段可能返回 null，表示取不到有效值。
     * @param MachineStatus 主机在线状态 OFFLINE  ONLINE
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setMachineStatus(String MachineStatus) {
        this.MachineStatus = MachineStatus;
    }

    /**
     * Get 状态；4-:待处理，5-已信任，6-已隔离
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Status 状态；4-:待处理，5-已信任，6-已隔离
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getStatus() {
        return this.Status;
    }

    /**
     * Set 状态；4-:待处理，5-已信任，6-已隔离
注意：此字段可能返回 null，表示取不到有效值。
     * @param Status 状态；4-:待处理，5-已信任，6-已隔离
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setStatus(Long Status) {
        this.Status = Status;
    }

    /**
     * Get 风险等级 0提示、1低、2中、3高、4严重
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Level 风险等级 0提示、1低、2中、3高、4严重
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getLevel() {
        return this.Level;
    }

    /**
     * Set 风险等级 0提示、1低、2中、3高、4严重
注意：此字段可能返回 null，表示取不到有效值。
     * @param Level 风险等级 0提示、1低、2中、3高、4严重
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setLevel(Long Level) {
        this.Level = Level;
    }

    /**
     * Get 木马检测平台用,分割 1云查杀引擎、2TAV、3binaryAi、4异常行为、5威胁情报
注意：此字段可能返回 null，表示取不到有效值。 
     * @return CheckPlatform 木马检测平台用,分割 1云查杀引擎、2TAV、3binaryAi、4异常行为、5威胁情报
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getCheckPlatform() {
        return this.CheckPlatform;
    }

    /**
     * Set 木马检测平台用,分割 1云查杀引擎、2TAV、3binaryAi、4异常行为、5威胁情报
注意：此字段可能返回 null，表示取不到有效值。
     * @param CheckPlatform 木马检测平台用,分割 1云查杀引擎、2TAV、3binaryAi、4异常行为、5威胁情报
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setCheckPlatform(String CheckPlatform) {
        this.CheckPlatform = CheckPlatform;
    }

    /**
     * Get 主机uuid
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Uuid 主机uuid
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getUuid() {
        return this.Uuid;
    }

    /**
     * Set 主机uuid
注意：此字段可能返回 null，表示取不到有效值。
     * @param Uuid 主机uuid
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setUuid(String Uuid) {
        this.Uuid = Uuid;
    }

    /**
     * Get 最近修改时间
注意：此字段可能返回 null，表示取不到有效值。 
     * @return ModifyTime 最近修改时间
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getModifyTime() {
        return this.ModifyTime;
    }

    /**
     * Set 最近修改时间
注意：此字段可能返回 null，表示取不到有效值。
     * @param ModifyTime 最近修改时间
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setModifyTime(String ModifyTime) {
        this.ModifyTime = ModifyTime;
    }

    /**
     * Get 最近访问时间
注意：此字段可能返回 null，表示取不到有效值。 
     * @return StrFileAccessTime 最近访问时间
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getStrFileAccessTime() {
        return this.StrFileAccessTime;
    }

    /**
     * Set 最近访问时间
注意：此字段可能返回 null，表示取不到有效值。
     * @param StrFileAccessTime 最近访问时间
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setStrFileAccessTime(String StrFileAccessTime) {
        this.StrFileAccessTime = StrFileAccessTime;
    }

    /**
     * Get 附加信息
注意：此字段可能返回 null，表示取不到有效值。 
     * @return MachineExtraInfo 附加信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public MachineExtraInfo getMachineExtraInfo() {
        return this.MachineExtraInfo;
    }

    /**
     * Set 附加信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param MachineExtraInfo 附加信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setMachineExtraInfo(MachineExtraInfo MachineExtraInfo) {
        this.MachineExtraInfo = MachineExtraInfo;
    }

    public MalwareInfo() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public MalwareInfo(MalwareInfo source) {
        if (source.VirusName != null) {
            this.VirusName = new String(source.VirusName);
        }
        if (source.FileSize != null) {
            this.FileSize = new Long(source.FileSize);
        }
        if (source.MD5 != null) {
            this.MD5 = new String(source.MD5);
        }
        if (source.FilePath != null) {
            this.FilePath = new String(source.FilePath);
        }
        if (source.FileCreateTime != null) {
            this.FileCreateTime = new String(source.FileCreateTime);
        }
        if (source.FileModifierTime != null) {
            this.FileModifierTime = new String(source.FileModifierTime);
        }
        if (source.HarmDescribe != null) {
            this.HarmDescribe = new String(source.HarmDescribe);
        }
        if (source.SuggestScheme != null) {
            this.SuggestScheme = new String(source.SuggestScheme);
        }
        if (source.ServersName != null) {
            this.ServersName = new String(source.ServersName);
        }
        if (source.HostIp != null) {
            this.HostIp = new String(source.HostIp);
        }
        if (source.ProcessName != null) {
            this.ProcessName = new String(source.ProcessName);
        }
        if (source.ProcessID != null) {
            this.ProcessID = new String(source.ProcessID);
        }
        if (source.Tags != null) {
            this.Tags = new String[source.Tags.length];
            for (int i = 0; i < source.Tags.length; i++) {
                this.Tags[i] = new String(source.Tags[i]);
            }
        }
        if (source.Breadth != null) {
            this.Breadth = new String(source.Breadth);
        }
        if (source.Heat != null) {
            this.Heat = new String(source.Heat);
        }
        if (source.Id != null) {
            this.Id = new Long(source.Id);
        }
        if (source.FileName != null) {
            this.FileName = new String(source.FileName);
        }
        if (source.CreateTime != null) {
            this.CreateTime = new String(source.CreateTime);
        }
        if (source.LatestScanTime != null) {
            this.LatestScanTime = new String(source.LatestScanTime);
        }
        if (source.Reference != null) {
            this.Reference = new String(source.Reference);
        }
        if (source.MachineWanIp != null) {
            this.MachineWanIp = new String(source.MachineWanIp);
        }
        if (source.PsTree != null) {
            this.PsTree = new String(source.PsTree);
        }
        if (source.MachineStatus != null) {
            this.MachineStatus = new String(source.MachineStatus);
        }
        if (source.Status != null) {
            this.Status = new Long(source.Status);
        }
        if (source.Level != null) {
            this.Level = new Long(source.Level);
        }
        if (source.CheckPlatform != null) {
            this.CheckPlatform = new String(source.CheckPlatform);
        }
        if (source.Uuid != null) {
            this.Uuid = new String(source.Uuid);
        }
        if (source.ModifyTime != null) {
            this.ModifyTime = new String(source.ModifyTime);
        }
        if (source.StrFileAccessTime != null) {
            this.StrFileAccessTime = new String(source.StrFileAccessTime);
        }
        if (source.MachineExtraInfo != null) {
            this.MachineExtraInfo = new MachineExtraInfo(source.MachineExtraInfo);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "VirusName", this.VirusName);
        this.setParamSimple(map, prefix + "FileSize", this.FileSize);
        this.setParamSimple(map, prefix + "MD5", this.MD5);
        this.setParamSimple(map, prefix + "FilePath", this.FilePath);
        this.setParamSimple(map, prefix + "FileCreateTime", this.FileCreateTime);
        this.setParamSimple(map, prefix + "FileModifierTime", this.FileModifierTime);
        this.setParamSimple(map, prefix + "HarmDescribe", this.HarmDescribe);
        this.setParamSimple(map, prefix + "SuggestScheme", this.SuggestScheme);
        this.setParamSimple(map, prefix + "ServersName", this.ServersName);
        this.setParamSimple(map, prefix + "HostIp", this.HostIp);
        this.setParamSimple(map, prefix + "ProcessName", this.ProcessName);
        this.setParamSimple(map, prefix + "ProcessID", this.ProcessID);
        this.setParamArraySimple(map, prefix + "Tags.", this.Tags);
        this.setParamSimple(map, prefix + "Breadth", this.Breadth);
        this.setParamSimple(map, prefix + "Heat", this.Heat);
        this.setParamSimple(map, prefix + "Id", this.Id);
        this.setParamSimple(map, prefix + "FileName", this.FileName);
        this.setParamSimple(map, prefix + "CreateTime", this.CreateTime);
        this.setParamSimple(map, prefix + "LatestScanTime", this.LatestScanTime);
        this.setParamSimple(map, prefix + "Reference", this.Reference);
        this.setParamSimple(map, prefix + "MachineWanIp", this.MachineWanIp);
        this.setParamSimple(map, prefix + "PsTree", this.PsTree);
        this.setParamSimple(map, prefix + "MachineStatus", this.MachineStatus);
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "Level", this.Level);
        this.setParamSimple(map, prefix + "CheckPlatform", this.CheckPlatform);
        this.setParamSimple(map, prefix + "Uuid", this.Uuid);
        this.setParamSimple(map, prefix + "ModifyTime", this.ModifyTime);
        this.setParamSimple(map, prefix + "StrFileAccessTime", this.StrFileAccessTime);
        this.setParamObj(map, prefix + "MachineExtraInfo.", this.MachineExtraInfo);

    }
}

