/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.vod.v20180717.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAnimatedGraphicsTemplatesResponse extends AbstractModel {

    /**
    * 符合过滤条件的记录总数。
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * 转动图模板详情列表。
    */
    @SerializedName("AnimatedGraphicsTemplateSet")
    @Expose
    private AnimatedGraphicsTemplate [] AnimatedGraphicsTemplateSet;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 符合过滤条件的记录总数。 
     * @return TotalCount 符合过滤条件的记录总数。
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set 符合过滤条件的记录总数。
     * @param TotalCount 符合过滤条件的记录总数。
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get 转动图模板详情列表。 
     * @return AnimatedGraphicsTemplateSet 转动图模板详情列表。
     */
    public AnimatedGraphicsTemplate [] getAnimatedGraphicsTemplateSet() {
        return this.AnimatedGraphicsTemplateSet;
    }

    /**
     * Set 转动图模板详情列表。
     * @param AnimatedGraphicsTemplateSet 转动图模板详情列表。
     */
    public void setAnimatedGraphicsTemplateSet(AnimatedGraphicsTemplate [] AnimatedGraphicsTemplateSet) {
        this.AnimatedGraphicsTemplateSet = AnimatedGraphicsTemplateSet;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAnimatedGraphicsTemplatesResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAnimatedGraphicsTemplatesResponse(DescribeAnimatedGraphicsTemplatesResponse source) {
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.AnimatedGraphicsTemplateSet != null) {
            this.AnimatedGraphicsTemplateSet = new AnimatedGraphicsTemplate[source.AnimatedGraphicsTemplateSet.length];
            for (int i = 0; i < source.AnimatedGraphicsTemplateSet.length; i++) {
                this.AnimatedGraphicsTemplateSet[i] = new AnimatedGraphicsTemplate(source.AnimatedGraphicsTemplateSet[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamArrayObj(map, prefix + "AnimatedGraphicsTemplateSet.", this.AnimatedGraphicsTemplateSet);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

