/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.weilingwith.v20230427.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class AlarmStatusData extends AbstractModel {

    /**
    * 告警状态ID
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("StatusID")
    @Expose
    private String StatusID;

    /**
    * 告警状态名称
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("StatusName")
    @Expose
    private String StatusName;

    /**
    * 告警状态类型
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("StatusType")
    @Expose
    private String StatusType;

    /**
     * Get 告警状态ID
注意：此字段可能返回 null，表示取不到有效值。 
     * @return StatusID 告警状态ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getStatusID() {
        return this.StatusID;
    }

    /**
     * Set 告警状态ID
注意：此字段可能返回 null，表示取不到有效值。
     * @param StatusID 告警状态ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setStatusID(String StatusID) {
        this.StatusID = StatusID;
    }

    /**
     * Get 告警状态名称
注意：此字段可能返回 null，表示取不到有效值。 
     * @return StatusName 告警状态名称
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getStatusName() {
        return this.StatusName;
    }

    /**
     * Set 告警状态名称
注意：此字段可能返回 null，表示取不到有效值。
     * @param StatusName 告警状态名称
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setStatusName(String StatusName) {
        this.StatusName = StatusName;
    }

    /**
     * Get 告警状态类型
注意：此字段可能返回 null，表示取不到有效值。 
     * @return StatusType 告警状态类型
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getStatusType() {
        return this.StatusType;
    }

    /**
     * Set 告警状态类型
注意：此字段可能返回 null，表示取不到有效值。
     * @param StatusType 告警状态类型
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setStatusType(String StatusType) {
        this.StatusType = StatusType;
    }

    public AlarmStatusData() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public AlarmStatusData(AlarmStatusData source) {
        if (source.StatusID != null) {
            this.StatusID = new String(source.StatusID);
        }
        if (source.StatusName != null) {
            this.StatusName = new String(source.StatusName);
        }
        if (source.StatusType != null) {
            this.StatusType = new String(source.StatusType);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "StatusID", this.StatusID);
        this.setParamSimple(map, prefix + "StatusName", this.StatusName);
        this.setParamSimple(map, prefix + "StatusType", this.StatusType);

    }
}

