/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xingyuv.jushauth.cache.AuthStateCache;
import com.xingyuv.jushauth.config.AuthConfig;
import com.xingyuv.jushauth.config.AuthDefaultSource;
import com.xingyuv.jushauth.enums.AuthToutiaoErrorCode;
import com.xingyuv.jushauth.enums.AuthUserGender;
import com.xingyuv.jushauth.exception.AuthException;
import com.xingyuv.jushauth.model.AuthCallback;
import com.xingyuv.jushauth.model.AuthToken;
import com.xingyuv.jushauth.model.AuthUser;
import com.xingyuv.jushauth.request.AuthDefaultRequest;
import com.xingyuv.jushauth.utils.UrlBuilder;

public class AuthToutiaoRequest
extends AuthDefaultRequest {
    public AuthToutiaoRequest(AuthConfig config) {
        super(config, AuthDefaultSource.TOUTIAO);
    }

    public AuthToutiaoRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.TOUTIAO, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        String response = this.doGetAuthorizationCode(authCallback.getCode());
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires_in")).openId(accessTokenObject.getString("open_id")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String userResponse = this.doGetUserInfo(authToken);
        JSONObject userProfile = JSONObject.parseObject((String)userResponse);
        this.checkResponse(userProfile);
        JSONObject user = userProfile.getJSONObject("data");
        boolean isAnonymousUser = user.getIntValue("uid_type") == 14;
        String anonymousUserName = "\u533f\u540d\u7528\u6237";
        return AuthUser.builder().rawUserInfo(user).uuid(user.getString("uid")).username(isAnonymousUser ? anonymousUserName : user.getString("screen_name")).nickname(isAnonymousUser ? anonymousUserName : user.getString("screen_name")).avatar(user.getString("avatar_url")).remark(user.getString("description")).gender(AuthUserGender.getRealGender(user.getString("gender"))).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_key", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("auth_only", 1).queryParam("display", 0).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return UrlBuilder.fromBaseUrl(this.source.accessToken()).queryParam("code", code).queryParam("client_key", this.config.getClientId()).queryParam("client_secret", this.config.getClientSecret()).queryParam("grant_type", "authorization_code").build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("client_key", this.config.getClientId()).queryParam("access_token", authToken.getAccessToken()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error_code")) {
            throw new AuthException(AuthToutiaoErrorCode.getErrorCode(object.getIntValue("error_code")).getDesc());
        }
    }
}

