/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.utils;

import com.xingyuv.jushauth.utils.Base64Utils;
import com.xingyuv.jushauth.utils.RandomUtil;
import com.xingyuv.jushauth.utils.Sha256;
import java.nio.charset.StandardCharsets;

public class PkceUtil {
    public static String generateCodeVerifier() {
        String randomStr = RandomUtil.randomString(50);
        return Base64Utils.encodeUrlSafe(randomStr);
    }

    public static String generateCodeChallenge(String codeChallengeMethod, String codeVerifier) {
        if ("S256".equalsIgnoreCase(codeChallengeMethod)) {
            return PkceUtil.newStringUsAscii(Base64Utils.encodeUrlSafe(Sha256.digest(codeVerifier), true));
        }
        return codeVerifier;
    }

    public static String newStringUsAscii(byte[] bytes) {
        return new String(bytes, StandardCharsets.US_ASCII);
    }
}

