/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf.configuration;

import de.codecentric.cxf.configuration.SoapMessageLoggerConfiguration;
import de.codecentric.cxf.configuration.XmlValidationConfiguration;
import de.codecentric.cxf.logging.LogCorrelationFilter;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ConditionalOnClass(value={CXFServlet.class})
@PropertySource(value={"classpath:spring-boot-starter-cxf.properties"})
@Import(value={XmlValidationConfiguration.class, SoapMessageLoggerConfiguration.class})
public class CxfAutoConfiguration {
    @Value(value="${soap.service.base.url:/soap-api}")
    private String baseUrl;
    @Value(value="${cxf.servicelist.title:CXF SpringBoot Starter - service list}")
    private String serviceListTitle;

    @Bean
    public ServletRegistrationBean cxfDispatcherServlet() {
        CXFServlet cxfServlet = new CXFServlet();
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)cxfServlet, new String[]{this.baseUrl + "/*"});
        Map initParameters = servletRegistrationBean.getInitParameters();
        initParameters.put("service-list-title", this.serviceListTitle);
        return servletRegistrationBean;
    }

    @Bean(name={"cxf"})
    public SpringBus springBus() {
        return new SpringBus();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Bean
    public Filter filter() {
        return new LogCorrelationFilter();
    }
}

