/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf.logging;

import de.codecentric.cxf.logging.BaseLogger;
import de.codecentric.cxf.logging.ElasticsearchField;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.MDC;

public class LogCorrelationFilter
implements Filter {
    private static final BaseLogger LOG = BaseLogger.getLogger(LogCorrelationFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long timeInbound = System.currentTimeMillis();
        MDC.put((String)ElasticsearchField.ID_KEY.getName(), (String)this.generateUUID());
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.logCallTime(timeInbound);
            MDC.remove((String)ElasticsearchField.ID_KEY.getName());
        }
    }

    private void logCallTime(long timeInbound) {
        long timeOutbound = System.currentTimeMillis();
        long calltime = timeOutbound - timeInbound;
        MDC.put((String)ElasticsearchField.TIME_CALLTIME.getName(), (String)String.valueOf(calltime));
        LOG.logCallTime(String.valueOf(calltime));
    }

    private String generateUUID() {
        return UUID.randomUUID().toString();
    }

    public void destroy() {
    }
}

