/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf.xmlvalidation;

import de.codecentric.cxf.common.FaultType;
import de.codecentric.cxf.common.XmlUtils;
import de.codecentric.cxf.logging.BaseLogger;
import de.codecentric.cxf.xmlvalidation.CustomFaultBuilder;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Fault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class SoapFaultBuilder {
    private static final String UNKNOWN_ERROR = "Unknown Error accured. Please contact support.";
    @Autowired(required=false)
    private CustomFaultBuilder customFaultBuilder;
    private static final BaseLogger LOG = BaseLogger.getLogger(SoapFaultBuilder.class);

    public void buildCustomFaultAndSet2SoapMessage(SoapMessage message, FaultType faultType) {
        Fault exceptionFault = (Fault)message.getContent(Exception.class);
        String originalFaultMessage = this.getMessageValueIfThere(exceptionFault);
        exceptionFault.setMessage(this.customFaultBuilder.createCustomFaultMessage(faultType));
        exceptionFault.setDetail(this.createFaultDetailWithCustomException(originalFaultMessage, faultType));
        message.setContent(Exception.class, (Object)exceptionFault);
    }

    private String getMessageValueIfThere(Fault exceptionFault) {
        if (exceptionFault.getMessage() != null) {
            return exceptionFault.getMessage();
        }
        return UNKNOWN_ERROR;
    }

    private Element createFaultDetailWithCustomException(String originalFaultMessage, FaultType faultContent) {
        Element exceptionElementAppended = null;
        try {
            Object faultDetail = this.customFaultBuilder.createCustomFaultDetail(originalFaultMessage, faultContent);
            Document faultDetailAsDoc = XmlUtils.marhallJaxbElement(faultDetail);
            exceptionElementAppended = XmlUtils.appendAsChildElement2NewElement(faultDetailAsDoc);
        }
        catch (Exception exception) {
            LOG.failedToBuildWeatherServiceCompliantSoapFaultDetails(exception);
        }
        return exceptionElementAppended;
    }
}

