/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.internal.Json;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolExecutor {
    private static final Logger log = LoggerFactory.getLogger(ToolExecutor.class);
    private final Object object;
    private final Method method;

    public ToolExecutor(Object object, Method method) {
        this.object = object;
        this.method = method;
    }

    public String execute(ToolExecutionRequest toolExecutionRequest) {
        log.debug("About to execute {}", (Object)toolExecutionRequest);
        Object[] arguments = this.prepareArguments(toolExecutionRequest.argumentsAsMap());
        try {
            String result = this.execute(arguments);
            log.debug("Tool execution result: {}", (Object)result);
            return result;
        }
        catch (IllegalAccessException e) {
            try {
                this.method.setAccessible(true);
                String result = this.execute(arguments);
                log.debug("Tool execution result: {}", (Object)result);
                return result;
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException(e2);
            }
            catch (InvocationTargetException e2) {
                Throwable cause = e2.getCause();
                log.error("Error while executing tool", cause);
                return cause.getMessage();
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            log.error("Error while executing tool", cause);
            return cause.getMessage();
        }
    }

    private String execute(Object[] arguments) throws IllegalAccessException, InvocationTargetException {
        Object result = this.method.invoke(this.object, arguments);
        if (this.method.getReturnType() == Void.TYPE) {
            return "Success";
        }
        return Json.toJson((Object)result);
    }

    private Object[] prepareArguments(Map<String, Object> argumentsMap) {
        Parameter[] parameters = this.method.getParameters();
        Object[] arguments = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String parameterName = parameters[i].getName();
            if (!argumentsMap.containsKey(parameterName)) continue;
            Object argument = argumentsMap.get(parameterName);
            Class<?> parameterType = parameters[i].getType();
            if (argument instanceof Double && parameterType != Double.class && parameterType != Double.TYPE) {
                Double doubleValue = (Double)argument;
                if (parameterType == Float.class || parameterType == Float.TYPE) {
                    if (doubleValue < -3.4028234663852886E38 || doubleValue > 3.4028234663852886E38) {
                        throw new IllegalArgumentException("Double value " + doubleValue + " is out of range for the float type");
                    }
                    argument = Float.valueOf(doubleValue.floatValue());
                } else if (parameterType == BigDecimal.class) {
                    argument = BigDecimal.valueOf(doubleValue);
                }
                if (ToolExecutor.hasNoFractionalPart(doubleValue)) {
                    if (parameterType == Integer.class || parameterType == Integer.TYPE) {
                        if (doubleValue < -2.147483648E9 || doubleValue > 2.147483647E9) {
                            throw new IllegalArgumentException("Double value " + doubleValue + " is out of range for the integer type");
                        }
                        argument = doubleValue.intValue();
                    } else if (parameterType == Long.class || parameterType == Long.TYPE) {
                        if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                            throw new IllegalArgumentException("Double value " + doubleValue + " is out of range for the long type");
                        }
                        argument = doubleValue.longValue();
                    } else if (parameterType == Short.class || parameterType == Short.TYPE) {
                        if (doubleValue < -32768.0 || doubleValue > 32767.0) {
                            throw new IllegalArgumentException("Double value " + doubleValue + " is out of range for the short type");
                        }
                        argument = doubleValue.shortValue();
                    } else if (parameterType == Byte.class || parameterType == Byte.TYPE) {
                        if (doubleValue < -128.0 || doubleValue > 127.0) {
                            throw new IllegalArgumentException("Double value " + doubleValue + " is out of range for the byte type");
                        }
                        argument = doubleValue.byteValue();
                    } else if (parameterType == BigInteger.class) {
                        argument = BigDecimal.valueOf(doubleValue).toBigInteger();
                    }
                }
            }
            arguments[i] = argument;
        }
        return arguments;
    }

    private static boolean hasNoFractionalPart(Double doubleValue) {
        return doubleValue.equals(Math.floor(doubleValue));
    }
}

