/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.chain;

import dev.langchain4j.chain.Chain;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.MessageWindowChatMemory;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.retriever.Retriever;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ConversationalRetrievalChain
implements Chain<String, String> {
    private static final PromptTemplate DEFAULT_PROMPT_TEMPLATE = PromptTemplate.from((String)"Answer the following question to the best of your ability: {{question}}\n\nBase your answer on the following information:\n{{information}}");
    private final ChatLanguageModel chatLanguageModel;
    private final ChatMemory chatMemory;
    private final PromptTemplate promptTemplate;
    private final Retriever<TextSegment> retriever;

    public ConversationalRetrievalChain(ChatLanguageModel chatLanguageModel, ChatMemory chatMemory, PromptTemplate promptTemplate, Retriever<TextSegment> retriever) {
        this.chatLanguageModel = (ChatLanguageModel)ValidationUtils.ensureNotNull((Object)chatLanguageModel, (String)"chatLanguageModel");
        this.chatMemory = chatMemory == null ? MessageWindowChatMemory.withMaxMessages(10) : chatMemory;
        this.promptTemplate = promptTemplate == null ? DEFAULT_PROMPT_TEMPLATE : promptTemplate;
        this.retriever = (Retriever)ValidationUtils.ensureNotNull(retriever, (String)"retriever");
    }

    public String execute(String question) {
        question = ValidationUtils.ensureNotBlank((String)question, (String)"question");
        List relevantSegments = this.retriever.findRelevant(question);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("question", question);
        variables.put("information", ConversationalRetrievalChain.format(relevantSegments));
        UserMessage userMessage = this.promptTemplate.apply(variables).toUserMessage();
        this.chatMemory.add((ChatMessage)userMessage);
        AiMessage answer = this.chatLanguageModel.sendMessages(this.chatMemory.messages());
        this.chatMemory.add((ChatMessage)answer);
        return answer.text();
    }

    private static String format(List<TextSegment> relevantSegments) {
        return relevantSegments.stream().map(TextSegment::text).map(segment -> "..." + segment + "...").collect(Collectors.joining("\n\n"));
    }

    public static ConversationalRetrievalChainBuilder builder() {
        return new ConversationalRetrievalChainBuilder();
    }

    public static class ConversationalRetrievalChainBuilder {
        private ChatLanguageModel chatLanguageModel;
        private ChatMemory chatMemory;
        private PromptTemplate promptTemplate;
        private Retriever<TextSegment> retriever;

        ConversationalRetrievalChainBuilder() {
        }

        public ConversationalRetrievalChainBuilder chatLanguageModel(ChatLanguageModel chatLanguageModel) {
            this.chatLanguageModel = chatLanguageModel;
            return this;
        }

        public ConversationalRetrievalChainBuilder chatMemory(ChatMemory chatMemory) {
            this.chatMemory = chatMemory;
            return this;
        }

        public ConversationalRetrievalChainBuilder promptTemplate(PromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        public ConversationalRetrievalChainBuilder retriever(Retriever<TextSegment> retriever) {
            this.retriever = retriever;
            return this;
        }

        public ConversationalRetrievalChain build() {
            return new ConversationalRetrievalChain(this.chatLanguageModel, this.chatMemory, this.promptTemplate, this.retriever);
        }

        public String toString() {
            return "ConversationalRetrievalChain.ConversationalRetrievalChainBuilder(chatLanguageModel=" + this.chatLanguageModel + ", chatMemory=" + this.chatMemory + ", promptTemplate=" + this.promptTemplate + ", retriever=" + this.retriever + ")";
        }
    }
}

