/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.DocumentSource;
import dev.langchain4j.data.document.DocumentType;
import dev.langchain4j.data.document.parser.MsOfficeDocumentParser;
import dev.langchain4j.data.document.parser.PdfDocumentParser;
import dev.langchain4j.data.document.parser.TextDocumentParser;
import java.io.InputStream;

class DocumentLoaderUtils {
    DocumentLoaderUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Document load(DocumentSource source, DocumentParser parser) {
        try (InputStream inputStream = source.inputStream();){
            Document document = parser.parse(inputStream);
            source.metadata().asMap().forEach((key, value) -> document.metadata().add(key, value));
            Document document2 = document;
            return document2;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load document", e);
        }
    }

    static DocumentParser parserFor(DocumentType type) {
        switch (type) {
            case TXT: 
            case HTML: {
                return new TextDocumentParser(type);
            }
            case PDF: {
                return new PdfDocumentParser();
            }
            case DOC: 
            case XLS: 
            case PPT: {
                return new MsOfficeDocumentParser(type);
            }
        }
        throw new RuntimeException(String.format("Cannot find parser for document type '%s'", new Object[]{type}));
    }
}

