/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document;

import dev.langchain4j.data.document.UnsupportedDocumentTypeException;
import java.util.Arrays;

public enum DocumentType {
    TXT("txt"),
    PDF("pdf"),
    HTML("html", "htm", "xhtml"),
    DOC("doc", "docx"),
    XLS("xls", "xlsx"),
    PPT("ppt", "pptx");

    private final Iterable<String> supportedExtensions;

    private DocumentType(String ... supportedExtensions) {
        this.supportedExtensions = Arrays.asList(supportedExtensions);
    }

    public static DocumentType of(String fileName) {
        for (DocumentType documentType : DocumentType.values()) {
            for (String supportedExtension : documentType.supportedExtensions) {
                if (!fileName.endsWith(supportedExtension)) continue;
                return documentType;
            }
        }
        throw new UnsupportedDocumentTypeException(fileName);
    }
}

