/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentLoaderUtils;
import dev.langchain4j.data.document.DocumentType;
import dev.langchain4j.data.document.UnsupportedDocumentTypeException;
import dev.langchain4j.data.document.source.FileSystemSource;
import dev.langchain4j.internal.Exceptions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemDocumentLoader {
    private static final Logger log = LoggerFactory.getLogger(FileSystemDocumentLoader.class);

    public static Document loadDocument(Path filePath) {
        return FileSystemDocumentLoader.loadDocument(filePath, DocumentType.of(filePath.toString()));
    }

    public static Document loadDocument(String filePath) {
        return FileSystemDocumentLoader.loadDocument(Paths.get(filePath, new String[0]));
    }

    public static Document loadDocument(Path filePath, DocumentType documentType) {
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            throw Exceptions.illegalArgument((String)"%s is not a file", (Object[])new Object[]{filePath});
        }
        return DocumentLoaderUtils.load(FileSystemSource.from(filePath), DocumentLoaderUtils.parserFor(documentType));
    }

    public static Document loadDocument(String filePath, DocumentType documentType) {
        return FileSystemDocumentLoader.loadDocument(Paths.get(filePath, new String[0]), documentType);
    }

    public static List<Document> loadDocuments(Path directoryPath) {
        if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
            throw Exceptions.illegalArgument((String)"%s is not a directory", (Object[])new Object[]{directoryPath});
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        try (Stream<Path> paths = Files.list(directoryPath);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(filePath -> {
                try {
                    Document document = FileSystemDocumentLoader.loadDocument(filePath);
                    documents.add(document);
                }
                catch (UnsupportedDocumentTypeException e) {
                    log.warn("Ignored unsupported document type", (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return documents;
    }

    public static List<Document> loadDocuments(String directoryPath) {
        return FileSystemDocumentLoader.loadDocuments(Paths.get(directoryPath, new String[0]));
    }
}

