/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentLoaderUtils;
import dev.langchain4j.data.document.DocumentType;
import dev.langchain4j.data.document.source.UrlSource;
import java.net.MalformedURLException;
import java.net.URL;

public class UrlDocumentLoader {
    public static Document load(URL url) {
        return UrlDocumentLoader.load(url, DocumentType.of(url.toString()));
    }

    public static Document load(String url) {
        try {
            return UrlDocumentLoader.load(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document load(URL url, DocumentType documentType) {
        return DocumentLoaderUtils.load(UrlSource.from(url), DocumentLoaderUtils.parserFor(documentType));
    }

    public static Document load(String url, DocumentType documentType) {
        try {
            return UrlDocumentLoader.load(new URL(url), documentType);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

