/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.parser;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.DocumentType;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.internal.ValidationUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class TextDocumentParser
implements DocumentParser {
    private final DocumentType documentType;
    private final Charset charset;

    public TextDocumentParser(DocumentType documentType) {
        this(documentType, StandardCharsets.UTF_8);
    }

    public TextDocumentParser(DocumentType documentType, Charset charset) {
        this.documentType = (DocumentType)((Object)ValidationUtils.ensureNotNull((Object)((Object)documentType), (String)"documentType"));
        this.charset = (Charset)ValidationUtils.ensureNotNull((Object)charset, (String)"charset");
    }

    public Document parse(InputStream inputStream) {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            String text = new String(buffer.toByteArray(), this.charset);
            return Document.from((String)text, (Metadata)new Metadata().add("document_type", (Object)this.documentType.toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

