/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.splitter;

import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.splitter.DocumentByWordSplitter;
import dev.langchain4j.data.document.splitter.HierarchicalDocumentSplitter;
import dev.langchain4j.model.Tokenizer;
import java.io.InputStream;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;

public class DocumentBySentenceSplitter
extends HierarchicalDocumentSplitter {
    private final SentenceDetectorME sentenceDetector = this.createSentenceDetector();

    public DocumentBySentenceSplitter(int maxSegmentSizeInChars) {
        super(maxSegmentSizeInChars, null, null);
    }

    public DocumentBySentenceSplitter(int maxSegmentSizeInChars, DocumentSplitter subSplitter) {
        super(maxSegmentSizeInChars, null, subSplitter);
    }

    public DocumentBySentenceSplitter(int maxSegmentSizeInTokens, Tokenizer tokenizer) {
        super(maxSegmentSizeInTokens, tokenizer, null);
    }

    public DocumentBySentenceSplitter(int maxSegmentSizeInTokens, Tokenizer tokenizer, DocumentSplitter subSplitter) {
        super(maxSegmentSizeInTokens, tokenizer, subSplitter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SentenceDetectorME createSentenceDetector() {
        String sentenceModelFilePath = "/opennlp/opennlp-en-ud-ewt-sentence-1.0-1.9.3.bin";
        try (InputStream is = this.getClass().getResourceAsStream(sentenceModelFilePath);){
            SentenceDetectorME sentenceDetectorME = new SentenceDetectorME(new SentenceModel(is));
            return sentenceDetectorME;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] split(String text) {
        return this.sentenceDetector.sentDetect(text);
    }

    @Override
    public String joinDelimiter() {
        return " ";
    }

    @Override
    protected DocumentSplitter defaultSubSplitter() {
        return new DocumentByWordSplitter(this.maxSegmentSize, this.tokenizer);
    }
}

