/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.splitter;

import dev.langchain4j.internal.ValidationUtils;
import java.util.function.Function;

class SegmentBuilder {
    private StringBuilder segmentBuilder = new StringBuilder();
    private final int maxSegmentSize;
    private final Function<String, Integer> sizeFunction;
    private final String joinSeparator;

    SegmentBuilder(int maxSegmentSize, Function<String, Integer> sizeFunction, String joinSeparator) {
        this.maxSegmentSize = ValidationUtils.ensureGreaterThanZero((Integer)maxSegmentSize, (String)"maxSegmentSize");
        this.sizeFunction = (Function)ValidationUtils.ensureNotNull(sizeFunction, (String)"sizeFunction");
        this.joinSeparator = (String)ValidationUtils.ensureNotNull((Object)joinSeparator, (String)"joinSeparator");
    }

    boolean hasSpaceFor(String text) {
        return this.hasSpaceFor(text, this.joinSeparator);
    }

    boolean hasSpaceFor(String text, String separator) {
        if (this.isNotEmpty()) {
            return this.sizeOf(this.segmentBuilder.toString()) + this.sizeOf(separator) + this.sizeOf(text) <= this.maxSegmentSize;
        }
        return this.sizeOf(text) <= this.maxSegmentSize;
    }

    private int sizeOf(String text) {
        return this.sizeFunction.apply(text);
    }

    void append(String text) {
        this.append(text, this.joinSeparator);
    }

    void append(String text, String separator) {
        if (this.segmentBuilder.length() > 0) {
            this.segmentBuilder.append(separator);
        }
        this.segmentBuilder.append(text);
    }

    boolean isNotEmpty() {
        return this.segmentBuilder.length() > 0;
    }

    String build() {
        return this.segmentBuilder.toString().trim();
    }

    void reset() {
        this.segmentBuilder = new StringBuilder();
    }
}

