/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.memory.chat;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.store.memory.chat.ChatMemoryStore;
import dev.langchain4j.store.memory.chat.InMemoryChatMemoryStore;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageWindowChatMemory
implements ChatMemory {
    private static final Logger log = LoggerFactory.getLogger(MessageWindowChatMemory.class);
    private final Object id;
    private final Integer maxMessages;
    private final ChatMemoryStore store;

    private MessageWindowChatMemory(Builder builder) {
        this.id = ValidationUtils.ensureNotNull((Object)builder.id, (String)"id");
        this.maxMessages = ValidationUtils.ensureGreaterThanZero((Integer)builder.maxMessages, (String)"maxMessages");
        this.store = (ChatMemoryStore)ValidationUtils.ensureNotNull((Object)builder.store, (String)"store");
    }

    public Object id() {
        return this.id;
    }

    public void add(ChatMessage message) {
        List<ChatMessage> messages = this.messages();
        messages.add(message);
        MessageWindowChatMemory.ensureCapacity(messages, this.maxMessages);
        this.store.updateMessages(this.id, messages);
    }

    public List<ChatMessage> messages() {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(this.store.getMessages(this.id));
        MessageWindowChatMemory.ensureCapacity(messages, this.maxMessages);
        return messages;
    }

    private static void ensureCapacity(List<ChatMessage> messages, int maxMessages) {
        int currentMessageCount;
        for (currentMessageCount = messages.size(); currentMessageCount > maxMessages; --currentMessageCount) {
            ChatMessage oldestMessage = messages.remove(0);
            log.trace("Removing the oldest message to comply with capacity requirements: {}", (Object)oldestMessage);
        }
        log.trace("Current message count: {}", (Object)currentMessageCount);
    }

    public void clear() {
        this.store.deleteMessages(this.id);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MessageWindowChatMemory withMaxMessages(int maxMessages) {
        return MessageWindowChatMemory.builder().maxMessages(maxMessages).build();
    }

    public static class Builder {
        private Object id = "default";
        private Integer maxMessages;
        private ChatMemoryStore store = new InMemoryChatMemoryStore();

        public Builder id(Object id) {
            this.id = id;
            return this;
        }

        public Builder maxMessages(Integer maxMessages) {
            this.maxMessages = maxMessages;
            return this;
        }

        public Builder chatMemoryStore(ChatMemoryStore store) {
            this.store = store;
            return this;
        }

        public MessageWindowChatMemory build() {
            return new MessageWindowChatMemory(this);
        }
    }
}

