/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.azure;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.completion.CompletionRequest;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.language.StreamingLanguageModel;
import dev.langchain4j.model.language.TokenCountEstimator;
import java.net.Proxy;
import java.time.Duration;

public class AzureOpenAiStreamingLanguageModel
implements StreamingLanguageModel,
TokenCountEstimator {
    private final OpenAiClient client;
    private final Double temperature;
    private final Tokenizer tokenizer;

    public AzureOpenAiStreamingLanguageModel(String baseUrl, String apiVersion, String apiKey, Tokenizer tokenizer, Double temperature, Duration timeout, Proxy proxy, Boolean logRequests, Boolean logResponses) {
        temperature = temperature == null ? 0.7 : temperature;
        timeout = timeout == null ? Duration.ofSeconds(15L) : timeout;
        this.client = OpenAiClient.builder().baseUrl(ValidationUtils.ensureNotBlank((String)baseUrl, (String)"baseUrl")).azureApiKey(apiKey).apiVersion(apiVersion).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).proxy(proxy).logRequests(logRequests).logStreamingResponses(logResponses).build();
        this.temperature = temperature;
        this.tokenizer = tokenizer;
    }

    public void process(String text, StreamingResponseHandler handler) {
        CompletionRequest request = CompletionRequest.builder().prompt(text).temperature(this.temperature).build();
        this.client.completion(request).onPartialResponse(partialResponse -> {
            String partialResponseText = partialResponse.text();
            if (partialResponseText != null) {
                handler.onNext(partialResponseText);
            }
        }).onComplete(() -> ((StreamingResponseHandler)handler).onComplete()).onError(arg_0 -> ((StreamingResponseHandler)handler).onError(arg_0)).execute();
    }

    public int estimateTokenCount(String prompt) {
        return this.tokenizer.estimateTokenCountInText(prompt);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String baseUrl;
        private String apiVersion;
        private String apiKey;
        private Tokenizer tokenizer;
        private Double temperature;
        private Duration timeout;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder tokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public AzureOpenAiStreamingLanguageModel build() {
            return new AzureOpenAiStreamingLanguageModel(this.baseUrl, this.apiVersion, this.apiKey, this.tokenizer, this.temperature, this.timeout, this.proxy, this.logRequests, this.logResponses);
        }
    }
}

