/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.huggingface;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.langchain4j.model.huggingface.ApiKeyInsertingInterceptor;
import dev.langchain4j.model.huggingface.EmbeddingRequest;
import dev.langchain4j.model.huggingface.HuggingFaceApi;
import dev.langchain4j.model.huggingface.TextGenerationRequest;
import dev.langchain4j.model.huggingface.TextGenerationResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class HuggingFaceClient {
    private final HuggingFaceApi huggingFaceApi;
    private final String modelId;

    HuggingFaceClient(String apiKey, String modelId, Duration timeout) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new ApiKeyInsertingInterceptor(apiKey)).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).build();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://api-inference.huggingface.co").client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
        this.huggingFaceApi = (HuggingFaceApi)retrofit.create(HuggingFaceApi.class);
        this.modelId = modelId;
    }

    TextGenerationResponse chat(TextGenerationRequest request) {
        return this.generate(request);
    }

    TextGenerationResponse generate(TextGenerationRequest request) {
        try {
            Response retrofitResponse = this.huggingFaceApi.generate(request, this.modelId).execute();
            if (retrofitResponse.isSuccessful()) {
                return HuggingFaceClient.toOneResponse((Response<List<TextGenerationResponse>>)retrofitResponse);
            }
            throw HuggingFaceClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static TextGenerationResponse toOneResponse(Response<List<TextGenerationResponse>> retrofitResponse) {
        List responses = (List)retrofitResponse.body();
        if (responses != null && responses.size() == 1) {
            return (TextGenerationResponse)responses.get(0);
        }
        throw new RuntimeException("Expected only one generated_text, but was: " + (responses == null ? 0 : responses.size()));
    }

    List<float[]> embed(EmbeddingRequest request) {
        try {
            Response retrofitResponse = this.huggingFaceApi.embed(request, this.modelId).execute();
            if (retrofitResponse.isSuccessful()) {
                return (List)retrofitResponse.body();
            }
            throw HuggingFaceClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static RuntimeException toException(Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }
}

