/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.huggingface;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.huggingface.EmbeddingRequest;
import dev.langchain4j.model.huggingface.HuggingFaceClient;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;

public class HuggingFaceEmbeddingModel
implements EmbeddingModel {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(15L);
    private final HuggingFaceClient client;
    private final boolean waitForModel;

    public HuggingFaceEmbeddingModel(String accessToken, String modelId, Boolean waitForModel, Duration timeout) {
        if (accessToken == null || accessToken.trim().isEmpty()) {
            throw new IllegalArgumentException("HuggingFace access token must be defined. It can be generated here: https://huggingface.co/settings/tokens");
        }
        this.client = new HuggingFaceClient(accessToken, modelId == null ? "sentence-transformers/all-MiniLM-L6-v2" : modelId, timeout == null ? DEFAULT_TIMEOUT : timeout);
        this.waitForModel = waitForModel == null ? true : waitForModel;
    }

    public List<Embedding> embedAll(List<TextSegment> textSegments) {
        List<String> texts = textSegments.stream().map(TextSegment::text).collect(Collectors.toList());
        return this.embedTexts(texts);
    }

    private List<Embedding> embedTexts(List<String> texts) {
        EmbeddingRequest request = new EmbeddingRequest(texts, this.waitForModel);
        List<float[]> response = this.client.embed(request);
        return response.stream().map(Embedding::from).collect(Collectors.toList());
    }

    public static HuggingFaceEmbeddingModel withAccessToken(String accessToken) {
        return HuggingFaceEmbeddingModel.builder().accessToken(accessToken).build();
    }

    public static HuggingFaceEmbeddingModelBuilder builder() {
        return new HuggingFaceEmbeddingModelBuilder();
    }

    public static class HuggingFaceEmbeddingModelBuilder {
        private String accessToken;
        private String modelId;
        private Boolean waitForModel;
        private Duration timeout;

        HuggingFaceEmbeddingModelBuilder() {
        }

        public HuggingFaceEmbeddingModelBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public HuggingFaceEmbeddingModelBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public HuggingFaceEmbeddingModelBuilder waitForModel(Boolean waitForModel) {
            this.waitForModel = waitForModel;
            return this;
        }

        public HuggingFaceEmbeddingModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public HuggingFaceEmbeddingModel build() {
            return new HuggingFaceEmbeddingModel(this.accessToken, this.modelId, this.waitForModel, this.timeout);
        }

        public String toString() {
            return "HuggingFaceEmbeddingModel.HuggingFaceEmbeddingModelBuilder(accessToken=" + this.accessToken + ", modelId=" + this.modelId + ", waitForModel=" + this.waitForModel + ", timeout=" + this.timeout + ")";
        }
    }
}

