/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.huggingface;

import dev.langchain4j.model.huggingface.HuggingFaceClient;
import dev.langchain4j.model.huggingface.Options;
import dev.langchain4j.model.huggingface.Parameters;
import dev.langchain4j.model.huggingface.TextGenerationRequest;
import dev.langchain4j.model.huggingface.TextGenerationResponse;
import dev.langchain4j.model.language.LanguageModel;
import java.time.Duration;

public class HuggingFaceLanguageModel
implements LanguageModel {
    private final HuggingFaceClient client;
    private final Double temperature;
    private final Integer maxNewTokens;
    private final Boolean returnFullText;
    private final Boolean waitForModel;

    public HuggingFaceLanguageModel(String accessToken, String modelId, Duration timeout, Double temperature, Integer maxNewTokens, Boolean returnFullText, Boolean waitForModel) {
        this(HuggingFaceLanguageModel.builder().accessToken(accessToken).modelId(modelId).timeout(timeout).temperature(temperature).maxNewTokens(maxNewTokens).returnFullText(returnFullText).waitForModel(waitForModel));
    }

    public HuggingFaceLanguageModel(Builder builder) {
        this.client = new HuggingFaceClient(builder.accessToken, builder.modelId, builder.timeout);
        this.temperature = builder.temperature;
        this.maxNewTokens = builder.maxNewTokens;
        this.returnFullText = builder.returnFullText;
        this.waitForModel = builder.waitForModel;
    }

    public String process(String text) {
        TextGenerationRequest request = TextGenerationRequest.builder().inputs(text).parameters(Parameters.builder().temperature(this.temperature).maxNewTokens(this.maxNewTokens).returnFullText(this.returnFullText).build()).options(Options.builder().waitForModel(this.waitForModel).build()).build();
        TextGenerationResponse response = this.client.generate(request);
        return response.generatedText();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HuggingFaceLanguageModel withAccessToken(String accessToken) {
        return HuggingFaceLanguageModel.builder().accessToken(accessToken).build();
    }

    public static final class Builder {
        private String accessToken;
        private String modelId = "tiiuae/falcon-7b-instruct";
        private Duration timeout = Duration.ofSeconds(15L);
        private Double temperature;
        private Integer maxNewTokens;
        private Boolean returnFullText = false;
        private Boolean waitForModel = true;

        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder modelId(String modelId) {
            if (modelId != null) {
                this.modelId = modelId;
            }
            return this;
        }

        public Builder timeout(Duration timeout) {
            if (timeout != null) {
                this.timeout = timeout;
            }
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder maxNewTokens(Integer maxNewTokens) {
            this.maxNewTokens = maxNewTokens;
            return this;
        }

        public Builder returnFullText(Boolean returnFullText) {
            if (returnFullText != null) {
                this.returnFullText = returnFullText;
            }
            return this;
        }

        public Builder waitForModel(Boolean waitForModel) {
            if (waitForModel != null) {
                this.waitForModel = waitForModel;
            }
            return this;
        }

        public HuggingFaceLanguageModel build() {
            if (this.accessToken == null || this.accessToken.trim().isEmpty()) {
                throw new IllegalArgumentException("HuggingFace access token must be defined. It can be generated here: https://huggingface.co/settings/tokens");
            }
            return new HuggingFaceLanguageModel(this);
        }
    }
}

