/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.inprocess;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.inprocess.InProcessEmbeddingModelType;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class InProcessEmbeddingModel
implements EmbeddingModel {
    private final EmbeddingModel implementation;

    public InProcessEmbeddingModel(InProcessEmbeddingModelType type) {
        try {
            this.implementation = InProcessEmbeddingModel.loadPrePackagedModelDynamically(type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(InProcessEmbeddingModel.errorMessageForPrePackagedModel(type), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InProcessEmbeddingModel(String pathToModel) {
        this(Paths.get(pathToModel, new String[0]));
    }

    public InProcessEmbeddingModel(Path pathToModel) {
        try {
            this.implementation = InProcessEmbeddingModel.loadCustomModelDynamically(pathToModel);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(InProcessEmbeddingModel.errorMessageForCustomModel(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static EmbeddingModel loadPrePackagedModelDynamically(InProcessEmbeddingModelType type) throws Exception {
        Class<?> implementationClass = Class.forName(String.format("dev.langchain4j.model.embedding.%s_EmbeddingModel", type.name()));
        return (EmbeddingModel)implementationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static EmbeddingModel loadCustomModelDynamically(Path pathToModel) throws Exception {
        Class<?> implementationClass = Class.forName("dev.langchain4j.model.embedding.CustomInProcessEmbeddingModel");
        Class[] constructorParameterTypes = new Class[]{Path.class};
        Constructor<?> constructor = implementationClass.getConstructor(constructorParameterTypes);
        return (EmbeddingModel)constructor.newInstance(pathToModel);
    }

    private static String errorMessageForPrePackagedModel(InProcessEmbeddingModelType type) {
        return String.format("To use %s embedding model, please add the following dependency to your project:\n\nMaven:\n<dependency>\n    <groupId>dev.langchain4j</groupId>\n    <artifactId>langchain4j-embeddings-%s</artifactId>\n    <version>0.22.0</version>\n</dependency>\n\nGradle:\nimplementation 'dev.langchain4j:langchain4j-embeddings-%s:0.22.0'\n", type.name(), type.name().replace("_", "-").toLowerCase(), type.name().replace("_", "-").toLowerCase());
    }

    private static String errorMessageForCustomModel() {
        return "To use custom embedding model, please add the following dependency to your project:\n\nMaven:\n<dependency>\n    <groupId>dev.langchain4j</groupId>\n    <artifactId>langchain4j-embeddings</artifactId>\n    <version>0.22.0</version>\n</dependency>\n\nGradle:\nimplementation 'dev.langchain4j:langchain4j-embeddings:0.22.0'\n";
    }

    public List<Embedding> embedAll(List<TextSegment> textSegments) {
        return this.implementation.embedAll(textSegments);
    }
}

