/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.moderation.ModerationRequest;
import dev.ai4j.openai4j.moderation.ModerationResponse;
import dev.ai4j.openai4j.moderation.ModerationResult;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.structured.StructuredPromptProcessor;
import dev.langchain4j.model.moderation.Moderation;
import dev.langchain4j.model.moderation.ModerationModel;
import java.net.Proxy;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class OpenAiModerationModel
implements ModerationModel {
    private final OpenAiClient client;
    private final String modelName;
    private final Integer maxRetries;

    public OpenAiModerationModel(String baseUrl, String apiKey, String modelName, Duration timeout, Integer maxRetries, Proxy proxy, Boolean logRequests, Boolean logResponses) {
        String string = baseUrl = baseUrl == null ? "https://api.openai.com/v1" : baseUrl;
        if ("demo".equals(apiKey)) {
            baseUrl = "http://langchain4j.dev/demo/openai/v1";
        }
        modelName = modelName == null ? "text-moderation-latest" : modelName;
        timeout = timeout == null ? Duration.ofSeconds(15L) : timeout;
        maxRetries = maxRetries == null ? 3 : maxRetries;
        this.client = OpenAiClient.builder().openAiApiKey(apiKey).baseUrl(baseUrl).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).proxy(proxy).logRequests(logRequests).logResponses(logResponses).build();
        this.modelName = modelName;
        this.maxRetries = maxRetries;
    }

    public Moderation moderate(String text) {
        return this.moderateInternal(Collections.singletonList(text));
    }

    private Moderation moderateInternal(List<String> inputs) {
        ModerationRequest request = ModerationRequest.builder().model(this.modelName).input(inputs).build();
        ModerationResponse response = (ModerationResponse)RetryUtils.withRetry(() -> (ModerationResponse)this.client.moderation(request).execute(), (int)this.maxRetries);
        int i = 0;
        for (ModerationResult moderationResult : response.results()) {
            if (moderationResult.isFlagged().booleanValue()) {
                return Moderation.flagged((String)inputs.get(i));
            }
            ++i;
        }
        return Moderation.notFlagged();
    }

    public Moderation moderate(Prompt prompt) {
        return this.moderate(prompt.text());
    }

    public Moderation moderate(Object structuredPrompt) {
        return this.moderate(StructuredPromptProcessor.toPrompt((Object)structuredPrompt));
    }

    public Moderation moderate(ChatMessage message) {
        return this.moderate(message.text());
    }

    public Moderation moderate(List<ChatMessage> messages) {
        List<String> inputs = messages.stream().map(ChatMessage::text).collect(Collectors.toList());
        return this.moderateInternal(inputs);
    }

    public Moderation moderate(TextSegment textSegment) {
        return this.moderate(textSegment.text());
    }

    public static OpenAiModerationModel withApiKey(String apiKey) {
        return OpenAiModerationModel.builder().apiKey(apiKey).build();
    }

    public static OpenAiModerationModelBuilder builder() {
        return new OpenAiModerationModelBuilder();
    }

    public static class OpenAiModerationModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Duration timeout;
        private Integer maxRetries;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;

        OpenAiModerationModelBuilder() {
        }

        public OpenAiModerationModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OpenAiModerationModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public OpenAiModerationModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OpenAiModerationModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OpenAiModerationModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OpenAiModerationModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public OpenAiModerationModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OpenAiModerationModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OpenAiModerationModel build() {
            return new OpenAiModerationModel(this.baseUrl, this.apiKey, this.modelName, this.timeout, this.maxRetries, this.proxy, this.logRequests, this.logResponses);
        }

        public String toString() {
            return "OpenAiModerationModel.OpenAiModerationModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", timeout=" + this.timeout + ", maxRetries=" + this.maxRetries + ", proxy=" + this.proxy + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }
}

