/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.completion.CompletionRequest;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.language.StreamingLanguageModel;
import dev.langchain4j.model.language.TokenCountEstimator;
import dev.langchain4j.model.openai.OpenAiTokenizer;
import java.net.Proxy;
import java.time.Duration;

public class OpenAiStreamingLanguageModel
implements StreamingLanguageModel,
TokenCountEstimator {
    private final OpenAiClient client;
    private final String modelName;
    private final Double temperature;
    private final Tokenizer tokenizer;

    public OpenAiStreamingLanguageModel(String baseUrl, String apiKey, String modelName, Double temperature, Duration timeout, Proxy proxy, Boolean logRequests, Boolean logResponses) {
        baseUrl = baseUrl == null ? "https://api.openai.com/v1" : baseUrl;
        modelName = modelName == null ? "text-davinci-003" : modelName;
        temperature = temperature == null ? 0.7 : temperature;
        timeout = timeout == null ? Duration.ofSeconds(60L) : timeout;
        this.client = OpenAiClient.builder().baseUrl(baseUrl).openAiApiKey(apiKey).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).proxy(proxy).logRequests(logRequests).logStreamingResponses(logResponses).build();
        this.modelName = modelName;
        this.temperature = temperature;
        this.tokenizer = new OpenAiTokenizer(this.modelName);
    }

    public void process(String text, StreamingResponseHandler handler) {
        CompletionRequest request = CompletionRequest.builder().model(this.modelName).prompt(text).temperature(this.temperature).build();
        this.client.completion(request).onPartialResponse(partialResponse -> {
            String partialResponseText = partialResponse.text();
            if (partialResponseText != null) {
                handler.onNext(partialResponseText);
            }
        }).onComplete(() -> ((StreamingResponseHandler)handler).onComplete()).onError(arg_0 -> ((StreamingResponseHandler)handler).onError(arg_0)).execute();
    }

    public int estimateTokenCount(String prompt) {
        return this.tokenizer.estimateTokenCountInText(prompt);
    }

    public static OpenAiStreamingLanguageModel withApiKey(String apiKey) {
        return OpenAiStreamingLanguageModel.builder().apiKey(apiKey).build();
    }

    public static OpenAiStreamingLanguageModelBuilder builder() {
        return new OpenAiStreamingLanguageModelBuilder();
    }

    public static class OpenAiStreamingLanguageModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Double temperature;
        private Duration timeout;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;

        OpenAiStreamingLanguageModelBuilder() {
        }

        public OpenAiStreamingLanguageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OpenAiStreamingLanguageModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OpenAiStreamingLanguageModel build() {
            return new OpenAiStreamingLanguageModel(this.baseUrl, this.apiKey, this.modelName, this.temperature, this.timeout, this.proxy, this.logRequests, this.logResponses);
        }

        public String toString() {
            return "OpenAiStreamingLanguageModel.OpenAiStreamingLanguageModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ", timeout=" + this.timeout + ", proxy=" + this.proxy + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }
}

