/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolExecutor;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.service.AiServiceContext;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AiServiceStreamingResponseHandler
implements StreamingResponseHandler {
    private final Logger log = LoggerFactory.getLogger(AiServiceStreamingResponseHandler.class);
    private final AiServiceContext context;
    private final Object memoryId;
    private final Consumer<String> tokenHandler;
    private final Runnable completionHandler;
    private final Consumer<Throwable> errorHandler;
    private final StringBuilder answerBuilder;
    private final StringBuilder toolNameBuilder;
    private final StringBuilder toolArgumentsBuilder;

    AiServiceStreamingResponseHandler(AiServiceContext context, Object memoryId, Consumer<String> tokenHandler, Runnable completionHandler, Consumer<Throwable> errorHandler) {
        this.context = (AiServiceContext)ValidationUtils.ensureNotNull((Object)context, (String)"context");
        this.memoryId = ValidationUtils.ensureNotNull((Object)memoryId, (String)"memoryId");
        this.tokenHandler = (Consumer)ValidationUtils.ensureNotNull(tokenHandler, (String)"tokenHandler");
        this.completionHandler = completionHandler;
        this.errorHandler = errorHandler;
        this.answerBuilder = new StringBuilder();
        this.toolNameBuilder = new StringBuilder();
        this.toolArgumentsBuilder = new StringBuilder();
    }

    public void onNext(String partialResult) {
        this.answerBuilder.append(partialResult);
        this.tokenHandler.accept(partialResult);
    }

    public void onToolName(String name) {
        this.toolNameBuilder.append(name);
    }

    public void onToolArguments(String arguments) {
        this.toolArgumentsBuilder.append(arguments);
    }

    public void onComplete() {
        String toolName = this.toolNameBuilder.toString();
        if (toolName.isEmpty()) {
            if (this.context.hasChatMemory()) {
                this.context.chatMemory(this.memoryId).add((ChatMessage)AiMessage.aiMessage((String)this.answerBuilder.toString()));
            }
            if (this.completionHandler != null) {
                this.completionHandler.run();
            }
        } else {
            ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().name(toolName).arguments(this.toolArgumentsBuilder.toString()).build();
            this.context.chatMemory(this.memoryId).add((ChatMessage)AiMessage.aiMessage((ToolExecutionRequest)toolExecutionRequest));
            ToolExecutor toolExecutor = this.context.toolExecutors.get(toolName);
            String toolExecutionResult = toolExecutor.execute(toolExecutionRequest);
            ToolExecutionResultMessage toolExecutionResultMessage = ToolExecutionResultMessage.toolExecutionResultMessage((String)toolExecutionRequest.name(), (String)toolExecutionResult);
            this.context.chatMemory(this.memoryId).add((ChatMessage)toolExecutionResultMessage);
            this.context.streamingChatLanguageModel.sendMessages(this.context.chatMemory(this.memoryId).messages(), this.context.toolSpecifications, (StreamingResponseHandler)new AiServiceStreamingResponseHandler(this.context, this.memoryId, this.tokenHandler, this.completionHandler, this.errorHandler));
        }
    }

    public void onError(Throwable error) {
        if (this.errorHandler != null) {
            try {
                this.errorHandler.accept(error);
            }
            catch (Exception e) {
                this.log.error("While handling the following error...", error);
                this.log.error("...the following error happened", (Throwable)e);
            }
        } else {
            this.log.warn("Ignored error", error);
        }
    }
}

