/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.chroma;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.chroma.AddEmbeddingsRequest;
import dev.langchain4j.store.embedding.chroma.ChromaClient;
import dev.langchain4j.store.embedding.chroma.Collection;
import dev.langchain4j.store.embedding.chroma.CreateCollectionRequest;
import dev.langchain4j.store.embedding.chroma.QueryRequest;
import dev.langchain4j.store.embedding.chroma.QueryResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ChromaEmbeddingStore
implements EmbeddingStore<TextSegment> {
    private final ChromaClient chromaClient;
    private final String collectionId;

    public ChromaEmbeddingStore(String baseUrl, String collectionName, Duration timeout) {
        collectionName = collectionName == null ? "default" : collectionName;
        timeout = timeout == null ? Duration.ofSeconds(5L) : timeout;
        this.chromaClient = new ChromaClient(baseUrl, timeout);
        Collection collection = this.chromaClient.collection(collectionName);
        if (collection == null) {
            Collection createdCollection = this.chromaClient.createCollection(new CreateCollectionRequest(collectionName));
            this.collectionId = createdCollection.id();
        } else {
            this.collectionId = collection.id();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public String add(Embedding embedding) {
        String id = Utils.randomUUID();
        this.add(id, embedding);
        return id;
    }

    public void add(String id, Embedding embedding) {
        this.addInternal(id, embedding, null);
    }

    public String add(Embedding embedding, TextSegment textSegment) {
        String id = Utils.randomUUID();
        this.addInternal(id, embedding, textSegment);
        return id;
    }

    public List<String> addAll(List<Embedding> embeddings) {
        List<String> ids = embeddings.stream().map(embedding -> Utils.randomUUID()).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, null);
        return ids;
    }

    public List<String> addAll(List<Embedding> embeddings, List<TextSegment> textSegments) {
        List<String> ids = embeddings.stream().map(embedding -> Utils.randomUUID()).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, textSegments);
        return ids;
    }

    private void addInternal(String id, Embedding embedding, TextSegment textSegment) {
        this.addAllInternal(Collections.singletonList(id), Collections.singletonList(embedding), textSegment == null ? null : Collections.singletonList(textSegment));
    }

    private void addAllInternal(List<String> ids, List<Embedding> embeddings, List<TextSegment> textSegments) {
        AddEmbeddingsRequest addEmbeddingsRequest = AddEmbeddingsRequest.builder().embeddings(embeddings.stream().map(Embedding::vector).collect(Collectors.toList())).ids(ids).metadatas(textSegments == null ? null : textSegments.stream().map(TextSegment::metadata).map(Metadata::asMap).collect(Collectors.toList())).documents(textSegments == null ? null : textSegments.stream().map(TextSegment::text).collect(Collectors.toList())).build();
        this.chromaClient.addEmbeddings(this.collectionId, addEmbeddingsRequest);
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding referenceEmbedding, int maxResults) {
        return this.findRelevant(referenceEmbedding, maxResults, 0.0);
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding referenceEmbedding, int maxResults, double minScore) {
        QueryRequest queryRequest = new QueryRequest(referenceEmbedding.vectorAsList(), maxResults);
        QueryResponse queryResponse = this.chromaClient.queryCollection(this.collectionId, queryRequest);
        return ChromaEmbeddingStore.toEmbeddingMatches(queryResponse);
    }

    private static List<EmbeddingMatch<TextSegment>> toEmbeddingMatches(QueryResponse queryResponse) {
        ArrayList<EmbeddingMatch<TextSegment>> embeddingMatches = new ArrayList<EmbeddingMatch<TextSegment>>();
        for (int i = 0; i < queryResponse.ids().get(0).size(); ++i) {
            double score = ChromaEmbeddingStore.distanceToScore(queryResponse.distances().get(0).get(i));
            String embeddingId = queryResponse.ids().get(0).get(i);
            Embedding embedding = Embedding.from(queryResponse.embeddings().get(0).get(i));
            TextSegment textSegment = ChromaEmbeddingStore.toTextSegment(queryResponse, i);
            embeddingMatches.add((EmbeddingMatch<TextSegment>)new EmbeddingMatch(Double.valueOf(score), embeddingId, embedding, (Object)textSegment));
        }
        return embeddingMatches;
    }

    private static double distanceToScore(double distance) {
        return 1.0 - distance / 2.0;
    }

    private static TextSegment toTextSegment(QueryResponse queryResponse, int i) {
        String text = queryResponse.documents().get(0).get(i);
        Map<String, String> metadata = queryResponse.metadatas().get(0).get(i);
        return text == null ? null : TextSegment.from((String)text, (Metadata)(metadata == null ? null : new Metadata(metadata)));
    }

    public static class Builder {
        private String baseUrl;
        private String collectionName;
        private Duration timeout;

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public ChromaEmbeddingStore build() {
            return new ChromaEmbeddingStore(this.baseUrl, this.collectionName, this.timeout);
        }
    }
}

