/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.inmemory;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.RelevanceScore;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;

public class InMemoryEmbeddingStore<Embedded>
implements EmbeddingStore<Embedded> {
    private final List<Entry<Embedded>> entries = new ArrayList<Entry<Embedded>>();

    public String add(Embedding embedding) {
        String id = Utils.randomUUID();
        this.add(id, embedding);
        return id;
    }

    public void add(String id, Embedding embedding) {
        this.add(id, embedding, null);
    }

    public String add(Embedding embedding, Embedded embedded) {
        String id = Utils.randomUUID();
        this.add(id, embedding, embedded);
        return id;
    }

    private void add(String id, Embedding embedding, Embedded embedded) {
        this.entries.add(new Entry<Embedded>(id, embedding, embedded));
    }

    public List<String> addAll(List<Embedding> embeddings) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Embedding embedding : embeddings) {
            ids.add(this.add(embedding));
        }
        return ids;
    }

    public List<String> addAll(List<Embedding> embeddings, List<Embedded> embedded) {
        if (embeddings.size() != embedded.size()) {
            throw new IllegalArgumentException("The list of embeddings and embedded must have the same size");
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < embeddings.size(); ++i) {
            ids.add(this.add(embeddings.get(i), embedded.get(i)));
        }
        return ids;
    }

    public List<EmbeddingMatch<Embedded>> findRelevant(Embedding referenceEmbedding, int maxResults, double minScore) {
        Comparator<EmbeddingMatch> comparator = Comparator.comparingDouble(EmbeddingMatch::score);
        PriorityQueue<EmbeddingMatch> matches = new PriorityQueue<EmbeddingMatch>(comparator);
        for (Entry<Embedded> entry : this.entries) {
            double score = RelevanceScore.cosine((float[])entry.embedding.vector(), (float[])referenceEmbedding.vector());
            if (!(score >= minScore)) continue;
            matches.add(new EmbeddingMatch(Double.valueOf(score), entry.id, entry.embedding, entry.embedded));
            if (matches.size() <= maxResults) continue;
            matches.poll();
        }
        ArrayList<EmbeddingMatch<Embedded>> result = new ArrayList<EmbeddingMatch<Embedded>>(matches);
        result.sort(comparator);
        Collections.reverse(result);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InMemoryEmbeddingStore that = (InMemoryEmbeddingStore)o;
        return Objects.equals(this.entries, that.entries);
    }

    public int hashCode() {
        return Objects.hash(this.entries);
    }

    public String serializeToJson() {
        return new Gson().toJson((Object)this);
    }

    public void serializeToFile(Path filePath) {
        try {
            String json = this.serializeToJson();
            Files.write(filePath, json.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void serializeToFile(String filePath) {
        this.serializeToFile(Paths.get(filePath, new String[0]));
    }

    public static InMemoryEmbeddingStore<TextSegment> fromJson(String json) {
        Type type = new TypeToken<InMemoryEmbeddingStore<TextSegment>>(){}.getType();
        return (InMemoryEmbeddingStore)new Gson().fromJson(json, type);
    }

    public static InMemoryEmbeddingStore<TextSegment> fromFile(Path filePath) {
        try {
            String json = new String(Files.readAllBytes(filePath));
            return InMemoryEmbeddingStore.fromJson(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InMemoryEmbeddingStore<TextSegment> fromFile(String filePath) {
        return InMemoryEmbeddingStore.fromFile(Paths.get(filePath, new String[0]));
    }

    private static class Entry<Embedded> {
        String id;
        Embedding embedding;
        Embedded embedded;

        Entry(String id, Embedding embedding, Embedded embedded) {
            this.id = id;
            this.embedding = embedding;
            this.embedded = embedded;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry that = (Entry)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.embedding, that.embedding) && Objects.equals(this.embedded, that.embedded);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.embedding, this.embedded);
        }
    }
}

