/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.milvus;

import dev.langchain4j.internal.ValidationUtils;

public class MilvusCollectionDescription {
    private String collectionName;
    private String idFieldName;
    private String vectorFieldName;
    private String scalarFieldName;

    public MilvusCollectionDescription(String collectionName, String idFieldName, String vectorFieldName, String scalarFieldName) {
        this.collectionName = ValidationUtils.ensureNotBlank((String)collectionName, (String)"collectionName");
        this.idFieldName = ValidationUtils.ensureNotBlank((String)idFieldName, (String)"idFieldName");
        this.vectorFieldName = ValidationUtils.ensureNotBlank((String)vectorFieldName, (String)"vectorFieldName");
        this.scalarFieldName = ValidationUtils.ensureNotBlank((String)scalarFieldName, (String)"scalarFieldName");
    }

    public String collectionName() {
        return this.collectionName;
    }

    public String idFieldName() {
        return this.idFieldName;
    }

    public String vectorFieldName() {
        return this.vectorFieldName;
    }

    public String scalarFieldName() {
        return this.scalarFieldName;
    }

    public static MilvusCollectionDescriptionBuilder builder() {
        return new MilvusCollectionDescriptionBuilder();
    }

    public static class MilvusCollectionDescriptionBuilder {
        private String collectionName;
        private String idFieldName;
        private String vectorFieldName;
        private String scalarFieldName;

        MilvusCollectionDescriptionBuilder() {
        }

        public MilvusCollectionDescriptionBuilder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public MilvusCollectionDescriptionBuilder idFieldName(String idFieldName) {
            this.idFieldName = idFieldName;
            return this;
        }

        public MilvusCollectionDescriptionBuilder vectorFieldName(String vectorFieldName) {
            this.vectorFieldName = vectorFieldName;
            return this;
        }

        public MilvusCollectionDescriptionBuilder scalarFieldName(String scalarFieldName) {
            this.scalarFieldName = scalarFieldName;
            return this;
        }

        public MilvusCollectionDescription build() {
            return new MilvusCollectionDescription(this.collectionName, this.idFieldName, this.vectorFieldName, this.scalarFieldName);
        }

        public String toString() {
            return "MilvusCollectionDescription.MilvusCollectionDescriptionBuilder(collectionName=" + this.collectionName + ", idFieldName=" + this.idFieldName + ", vectorFieldName=" + this.vectorFieldName + ", scalarFieldName=" + this.scalarFieldName + ")";
        }
    }
}

