/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.milvus;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.milvus.MilvusCollectionDescription;
import dev.langchain4j.store.embedding.milvus.MilvusOperationsParams;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class MilvusEmbeddingStore
implements EmbeddingStore<TextSegment> {
    private final EmbeddingStore<TextSegment> implementation;

    public MilvusEmbeddingStore(String host, int port, String databaseName, String uri, String token, boolean secure, String username, String password, MilvusCollectionDescription collectionDescription, MilvusOperationsParams operationsParams) {
        try {
            this.implementation = MilvusEmbeddingStore.loadDynamically("dev.langchain4j.store.embedding.MilvusEmbeddingStoreImpl", host, port, databaseName, uri, token, secure, username, password, collectionDescription, operationsParams);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(MilvusEmbeddingStore.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String add(Embedding embedding) {
        return this.implementation.add(embedding);
    }

    public void add(String id, Embedding embedding) {
        this.implementation.add(id, embedding);
    }

    public String add(Embedding embedding, TextSegment textSegment) {
        return this.implementation.add(embedding, (Object)textSegment);
    }

    public List<String> addAll(List<Embedding> embeddings) {
        return this.implementation.addAll(embeddings);
    }

    public List<String> addAll(List<Embedding> embeddings, List<TextSegment> embedded) {
        return this.implementation.addAll(embeddings, embedded);
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding referenceEmbedding, int maxResults) {
        return this.implementation.findRelevant(referenceEmbedding, maxResults);
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding referenceEmbedding, int maxResults, double minSimilarity) {
        return this.implementation.findRelevant(referenceEmbedding, maxResults, minSimilarity);
    }

    private static EmbeddingStore<TextSegment> loadDynamically(String implementationClassName, String host, int port, String databaseName, String uri, String token, boolean secure, String username, String password, MilvusCollectionDescription collectionDescription, MilvusOperationsParams operationsParams) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> implementationClass = Class.forName(implementationClassName);
        Class[] constructorParameterTypes = new Class[]{String.class, Integer.TYPE, String.class, String.class, String.class, Boolean.TYPE, String.class, String.class, MilvusCollectionDescription.class, MilvusOperationsParams.class};
        Constructor<?> constructor = implementationClass.getConstructor(constructorParameterTypes);
        return (EmbeddingStore)constructor.newInstance(host, port, databaseName, uri, token, secure, username, password, collectionDescription, operationsParams);
    }

    private static String getMessage() {
        return "To use MilvusEmbeddingStore, please add the following dependency to your project:\n\nMaven:\n<dependency>\n    <groupId>dev.langchain4j</groupId>\n    <artifactId>langchain4j-milvus</artifactId>\n    <version>0.22.0</version>\n</dependency>\n\nGradle:\nimplementation 'dev.langchain4j:langchain4j-milvus:0.22.0'\n";
    }

    public static MilvusEmbeddingStoreBuilder builder() {
        return new MilvusEmbeddingStoreBuilder();
    }

    public static class MilvusEmbeddingStoreBuilder {
        private String host;
        private int port;
        private String databaseName;
        private String uri;
        private String token;
        private boolean secure;
        private String username;
        private String password;
        private MilvusCollectionDescription collectionDescription;
        private MilvusOperationsParams operationsParams;

        MilvusEmbeddingStoreBuilder() {
        }

        public MilvusEmbeddingStoreBuilder host(String host) {
            this.host = host;
            return this;
        }

        public MilvusEmbeddingStoreBuilder port(int port) {
            this.port = port;
            return this;
        }

        public MilvusEmbeddingStoreBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public MilvusEmbeddingStoreBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public MilvusEmbeddingStoreBuilder token(String token) {
            this.token = token;
            return this;
        }

        public MilvusEmbeddingStoreBuilder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public MilvusEmbeddingStoreBuilder username(String username) {
            this.username = username;
            return this;
        }

        public MilvusEmbeddingStoreBuilder password(String password) {
            this.password = password;
            return this;
        }

        public MilvusEmbeddingStoreBuilder collectionDescription(MilvusCollectionDescription collectionDescription) {
            this.collectionDescription = collectionDescription;
            return this;
        }

        public MilvusEmbeddingStoreBuilder operationsParams(MilvusOperationsParams operationsParams) {
            this.operationsParams = operationsParams;
            return this;
        }

        public MilvusEmbeddingStore build() {
            return new MilvusEmbeddingStore(this.host, this.port, this.databaseName, this.uri, this.token, this.secure, this.username, this.password, this.collectionDescription, this.operationsParams);
        }

        public String toString() {
            return "MilvusEmbeddingStore.MilvusEmbeddingStoreBuilder(host=" + this.host + ", port=" + this.port + ", databaseName=" + this.databaseName + ", uri=" + this.uri + ", token=" + this.token + ", secure=" + this.secure + ", username=" + this.username + ", password=" + this.password + ", collectionDescription=" + this.collectionDescription + ", operationsParams=" + this.operationsParams + ")";
        }
    }
}

