/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.pinecone;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class PineconeEmbeddingStore
implements EmbeddingStore<TextSegment> {
    private final EmbeddingStore<TextSegment> implementation;

    public PineconeEmbeddingStore(String apiKey, String environment, String projectId, String index, String nameSpace) {
        try {
            this.implementation = PineconeEmbeddingStore.loadDynamically("dev.langchain4j.store.embedding.pinecone.PineconeEmbeddingStoreImpl", apiKey, environment, projectId, index, nameSpace);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(PineconeEmbeddingStore.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getMessage() {
        return "To use PineconeEmbeddingStore, please add the following dependency to your project:\n\nMaven:\n<dependency>\n    <groupId>dev.langchain4j</groupId>\n    <artifactId>langchain4j-pinecone</artifactId>\n    <version>0.22.0</version>\n</dependency>\n\nGradle:\nimplementation 'dev.langchain4j:langchain4j-pinecone:0.22.0'\n";
    }

    private static EmbeddingStore<TextSegment> loadDynamically(String implementationClassName, String apiKey, String environment, String project, String index, String nameSpace) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> implementationClass = Class.forName(implementationClassName);
        Class[] constructorParameterTypes = new Class[]{String.class, String.class, String.class, String.class, String.class};
        Constructor<?> constructor = implementationClass.getConstructor(constructorParameterTypes);
        return (EmbeddingStore)constructor.newInstance(apiKey, environment, project, index, nameSpace);
    }

    public String add(Embedding embedding) {
        return this.implementation.add(embedding);
    }

    public void add(String id, Embedding embedding) {
        this.implementation.add(id, embedding);
    }

    public String add(Embedding embedding, TextSegment textSegment) {
        return this.implementation.add(embedding, (Object)textSegment);
    }

    public List<String> addAll(List<Embedding> embeddings) {
        return this.implementation.addAll(embeddings);
    }

    public List<String> addAll(List<Embedding> embeddings, List<TextSegment> textSegments) {
        return this.implementation.addAll(embeddings, textSegments);
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding referenceEmbedding, int maxResults) {
        return this.implementation.findRelevant(referenceEmbedding, maxResults);
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding referenceEmbedding, int maxResults, double minScore) {
        return this.implementation.findRelevant(referenceEmbedding, maxResults, minScore);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String apiKey;
        private String environment;
        private String projectId;
        private String index;
        private String nameSpace;

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder nameSpace(String nameSpace) {
            this.nameSpace = nameSpace;
            return this;
        }

        public PineconeEmbeddingStore build() {
            return new PineconeEmbeddingStore(this.apiKey, this.environment, this.projectId, this.index, this.nameSpace);
        }
    }
}

