/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.weaviate;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class WeaviateEmbeddingStore
implements EmbeddingStore<TextSegment> {
    private final EmbeddingStore<TextSegment> implementation;

    public WeaviateEmbeddingStore(String apiKey, String scheme, String host, String objectClass, boolean avoidDups, String consistencyLevel) {
        try {
            this.implementation = WeaviateEmbeddingStore.loadDynamically("dev.langchain4j.store.embedding.weaviate.WeaviateEmbeddingStoreImpl", apiKey, scheme, host, objectClass, avoidDups, consistencyLevel);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(WeaviateEmbeddingStore.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getMessage() {
        return "To use WeaviateEmbeddingStore, please add the following dependency to your project:\n\nMaven:\n<dependency>\n    <groupId>dev.langchain4j</groupId>\n    <artifactId>langchain4j-weaviate</artifactId>\n    <version>0.22.0</version>\n</dependency>\n\nGradle:\nimplementation 'dev.langchain4j:langchain4j-weaviate:0.22.0'\n";
    }

    private static EmbeddingStore<TextSegment> loadDynamically(String implementationClassName, String apiKey, String scheme, String host, String objectClass, boolean avoidDups, String consistencyLevel) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> implementationClass = Class.forName(implementationClassName);
        Class[] constructorParameterTypes = new Class[]{String.class, String.class, String.class, String.class, Boolean.TYPE, String.class};
        Constructor<?> constructor = implementationClass.getConstructor(constructorParameterTypes);
        return (EmbeddingStore)constructor.newInstance(apiKey, scheme, host, objectClass, avoidDups, consistencyLevel);
    }

    public String add(Embedding embedding) {
        return this.implementation.add(embedding);
    }

    public void add(String id, Embedding embedding) {
        this.implementation.add(id, embedding);
    }

    public String add(Embedding embedding, TextSegment textSegment) {
        return this.implementation.add(embedding, (Object)textSegment);
    }

    public List<String> addAll(List<Embedding> embeddings) {
        return this.implementation.addAll(embeddings);
    }

    public List<String> addAll(List<Embedding> embeddings, List<TextSegment> textSegments) {
        return this.implementation.addAll(embeddings, textSegments);
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding referenceEmbedding, int maxResults) {
        return this.implementation.findRelevant(referenceEmbedding, maxResults);
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding referenceEmbedding, int maxResults, double minScore) {
        return this.implementation.findRelevant(referenceEmbedding, maxResults, minScore);
    }

    public static WeaviateEmbeddingStoreBuilder builder() {
        return new WeaviateEmbeddingStoreBuilder();
    }

    public static class WeaviateEmbeddingStoreBuilder {
        private String apiKey;
        private String scheme;
        private String host;
        private String objectClass;
        private boolean avoidDups;
        private String consistencyLevel;

        WeaviateEmbeddingStoreBuilder() {
        }

        public WeaviateEmbeddingStoreBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public WeaviateEmbeddingStoreBuilder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public WeaviateEmbeddingStoreBuilder host(String host) {
            this.host = host;
            return this;
        }

        public WeaviateEmbeddingStoreBuilder objectClass(String objectClass) {
            this.objectClass = objectClass;
            return this;
        }

        public WeaviateEmbeddingStoreBuilder avoidDups(boolean avoidDups) {
            this.avoidDups = avoidDups;
            return this;
        }

        public WeaviateEmbeddingStoreBuilder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public WeaviateEmbeddingStore build() {
            return new WeaviateEmbeddingStore(this.apiKey, this.scheme, this.host, this.objectClass, this.avoidDups, this.consistencyLevel);
        }

        public String toString() {
            return "WeaviateEmbeddingStore.WeaviateEmbeddingStoreBuilder(apiKey=" + this.apiKey + ", scheme=" + this.scheme + ", host=" + this.host + ", objectClass=" + this.objectClass + ", avoidDups=" + this.avoidDups + ", consistencyLevel=" + this.consistencyLevel + ")";
        }
    }
}

