/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.loader;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentLoader;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.DocumentSource;
import dev.langchain4j.data.document.source.FileSystemSource;
import dev.langchain4j.internal.Exceptions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemDocumentLoader {
    private static final Logger log = LoggerFactory.getLogger(FileSystemDocumentLoader.class);

    private FileSystemDocumentLoader() {
    }

    public static Document loadDocument(Path filePath, DocumentParser documentParser) {
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            throw Exceptions.illegalArgument((String)"%s is not a file", (Object[])new Object[]{filePath});
        }
        return DocumentLoader.load((DocumentSource)FileSystemSource.from(filePath), (DocumentParser)documentParser);
    }

    public static Document loadDocument(String filePath, DocumentParser documentParser) {
        return FileSystemDocumentLoader.loadDocument(Paths.get(filePath, new String[0]), documentParser);
    }

    public static List<Document> loadDocuments(Path directoryPath, DocumentParser documentParser) {
        if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
            throw Exceptions.illegalArgument((String)"%s is not a directory", (Object[])new Object[]{directoryPath});
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        try (Stream<Path> files = Files.list(directoryPath);){
            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                try {
                    Document document = FileSystemDocumentLoader.loadDocument(file, documentParser);
                    documents.add(document);
                }
                catch (Exception e) {
                    log.warn("Failed to load document from " + file, (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return documents;
    }

    public static List<Document> loadDocuments(String directoryPath, DocumentParser documentParser) {
        return FileSystemDocumentLoader.loadDocuments(Paths.get(directoryPath, new String[0]), documentParser);
    }
}

