/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.memory.chat;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.store.memory.chat.ChatMemoryStore;
import dev.langchain4j.store.memory.chat.InMemoryChatMemoryStore;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenWindowChatMemory
implements ChatMemory {
    private static final Logger log = LoggerFactory.getLogger(TokenWindowChatMemory.class);
    private final Object id;
    private final Integer maxTokens;
    private final Tokenizer tokenizer;
    private final ChatMemoryStore store;

    private TokenWindowChatMemory(Builder builder) {
        this.id = ValidationUtils.ensureNotNull((Object)builder.id, (String)"id");
        this.maxTokens = ValidationUtils.ensureGreaterThanZero((Integer)builder.maxTokens, (String)"maxTokens");
        this.tokenizer = (Tokenizer)ValidationUtils.ensureNotNull((Object)builder.tokenizer, (String)"tokenizer");
        this.store = (ChatMemoryStore)ValidationUtils.ensureNotNull((Object)builder.store, (String)"store");
    }

    public Object id() {
        return this.id;
    }

    public void add(ChatMessage message) {
        Optional<SystemMessage> maybeSystemMessage;
        List<ChatMessage> messages = this.messages();
        if (message instanceof SystemMessage && (maybeSystemMessage = TokenWindowChatMemory.findSystemMessage(messages)).isPresent()) {
            if (maybeSystemMessage.get().equals((Object)message)) {
                return;
            }
            messages.remove(maybeSystemMessage.get());
        }
        messages.add(message);
        TokenWindowChatMemory.ensureCapacity(messages, this.maxTokens, this.tokenizer);
        this.store.updateMessages(this.id, messages);
    }

    private static Optional<SystemMessage> findSystemMessage(List<ChatMessage> messages) {
        return messages.stream().filter(message -> message instanceof SystemMessage).map(message -> (SystemMessage)message).findAny();
    }

    public List<ChatMessage> messages() {
        LinkedList<ChatMessage> messages = new LinkedList<ChatMessage>(this.store.getMessages(this.id));
        TokenWindowChatMemory.ensureCapacity(messages, this.maxTokens, this.tokenizer);
        return messages;
    }

    private static void ensureCapacity(List<ChatMessage> messages, int maxTokens, Tokenizer tokenizer) {
        int tokenCountOfRemovedMessage;
        for (int currentTokenCount = tokenizer.estimateTokenCountInMessages(messages); currentTokenCount > maxTokens; currentTokenCount -= tokenCountOfRemovedMessage) {
            int messageToRemove = 0;
            if (messages.get(0) instanceof SystemMessage) {
                messageToRemove = 1;
            }
            ChatMessage removedMessage = messages.remove(messageToRemove);
            tokenCountOfRemovedMessage = tokenizer.estimateTokenCountInMessage(removedMessage);
            log.trace("Removing the following message ({} tokens) to comply with the capacity requirements: {}", (Object)tokenCountOfRemovedMessage, (Object)removedMessage);
        }
    }

    public void clear() {
        this.store.deleteMessages(this.id);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TokenWindowChatMemory withMaxTokens(int maxTokens, Tokenizer tokenizer) {
        return TokenWindowChatMemory.builder().maxTokens(maxTokens, tokenizer).build();
    }

    public static class Builder {
        private Object id = "default";
        private Integer maxTokens;
        private Tokenizer tokenizer;
        private ChatMemoryStore store = new InMemoryChatMemoryStore();

        public Builder id(Object id) {
            this.id = id;
            return this;
        }

        public Builder maxTokens(Integer maxTokens, Tokenizer tokenizer) {
            this.maxTokens = maxTokens;
            this.tokenizer = tokenizer;
            return this;
        }

        public Builder chatMemoryStore(ChatMemoryStore store) {
            this.store = store;
            return this;
        }

        public TokenWindowChatMemory build() {
            return new TokenWindowChatMemory(this);
        }
    }
}

