/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.agent.tool.DefaultToolExecutor;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolExecutor;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.exception.IllegalConfigurationException;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.moderation.Moderation;
import dev.langchain4j.model.moderation.ModerationModel;
import dev.langchain4j.rag.DefaultRetrievalAugmentor;
import dev.langchain4j.rag.RetrievalAugmentor;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.retriever.Retriever;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.DefaultAiServices;
import dev.langchain4j.service.ModerationException;
import dev.langchain4j.spi.ServiceHelper;
import dev.langchain4j.spi.services.AiServicesFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public abstract class AiServices<T> {
    protected static final String DEFAULT = "default";
    protected final AiServiceContext context;

    protected AiServices(AiServiceContext context) {
        this.context = context;
    }

    public static <T> T create(Class<T> aiService, ChatLanguageModel chatLanguageModel) {
        return AiServices.builder(aiService).chatLanguageModel(chatLanguageModel).build();
    }

    public static <T> T create(Class<T> aiService, StreamingChatLanguageModel streamingChatLanguageModel) {
        return AiServices.builder(aiService).streamingChatLanguageModel(streamingChatLanguageModel).build();
    }

    public static <T> AiServices<T> builder(Class<T> aiService) {
        AiServiceContext context = new AiServiceContext(aiService);
        Iterator iterator = ServiceHelper.loadFactories(AiServicesFactory.class).iterator();
        if (iterator.hasNext()) {
            AiServicesFactory factory = (AiServicesFactory)iterator.next();
            return factory.create(context);
        }
        return new DefaultAiServices(context);
    }

    public AiServices<T> chatLanguageModel(ChatLanguageModel chatLanguageModel) {
        this.context.chatModel = chatLanguageModel;
        return this;
    }

    public AiServices<T> streamingChatLanguageModel(StreamingChatLanguageModel streamingChatLanguageModel) {
        this.context.streamingChatModel = streamingChatLanguageModel;
        return this;
    }

    public AiServices<T> chatMemory(ChatMemory chatMemory) {
        this.context.chatMemories = new ConcurrentHashMap<Object, ChatMemory>();
        this.context.chatMemories.put(DEFAULT, chatMemory);
        return this;
    }

    public AiServices<T> chatMemoryProvider(ChatMemoryProvider chatMemoryProvider) {
        this.context.chatMemories = new ConcurrentHashMap<Object, ChatMemory>();
        this.context.chatMemoryProvider = chatMemoryProvider;
        return this;
    }

    public AiServices<T> moderationModel(ModerationModel moderationModel) {
        this.context.moderationModel = moderationModel;
        return this;
    }

    public AiServices<T> tools(Object ... objectsWithTools) {
        return this.tools(Arrays.asList(objectsWithTools));
    }

    public AiServices<T> tools(List<Object> objectsWithTools) {
        this.context.toolSpecifications = new ArrayList<ToolSpecification>();
        this.context.toolExecutors = new HashMap<String, ToolExecutor>();
        for (Object objectWithTool : objectsWithTools) {
            for (Method method : objectWithTool.getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Tool.class)) continue;
                ToolSpecification toolSpecification = ToolSpecifications.toolSpecificationFrom((Method)method);
                this.context.toolSpecifications.add(toolSpecification);
                this.context.toolExecutors.put(toolSpecification.name(), new DefaultToolExecutor(objectWithTool, method));
            }
        }
        return this;
    }

    @Deprecated
    public AiServices<T> retriever(Retriever<TextSegment> retriever) {
        if (retriever != null) {
            return this.contentRetriever(retriever.toContentRetriever());
        }
        return this;
    }

    public AiServices<T> contentRetriever(ContentRetriever contentRetriever) {
        this.context.retrievalAugmentor = DefaultRetrievalAugmentor.builder().contentRetriever((ContentRetriever)ValidationUtils.ensureNotNull((Object)contentRetriever, (String)"contentRetriever")).build();
        return this;
    }

    public AiServices<T> retrievalAugmentor(RetrievalAugmentor retrievalAugmentor) {
        this.context.retrievalAugmentor = (RetrievalAugmentor)ValidationUtils.ensureNotNull((Object)retrievalAugmentor, (String)"retrievalAugmentor");
        return this;
    }

    public abstract T build();

    protected void performBasicValidation() {
        if (this.context.chatModel == null && this.context.streamingChatModel == null) {
            throw IllegalConfigurationException.illegalConfiguration("Please specify either chatLanguageModel or streamingChatLanguageModel");
        }
        if (this.context.toolSpecifications != null && !this.context.hasChatMemory()) {
            throw IllegalConfigurationException.illegalConfiguration("Please set up chatMemory or chatMemoryProvider in order to use tools. A ChatMemory that can hold at least 3 messages is required for the tools to work properly. While the LLM can technically execute a tool without chat memory, if it only receives the result of the tool's execution without the initial message from the user, it won't interpret the result properly.");
        }
    }

    public static List<ChatMessage> removeToolMessages(List<ChatMessage> messages) {
        return messages.stream().filter(it -> !(it instanceof ToolExecutionResultMessage)).filter(it -> !(it instanceof AiMessage) || !((AiMessage)it).hasToolExecutionRequests()).collect(Collectors.toList());
    }

    public static void verifyModerationIfNeeded(Future<Moderation> moderationFuture) {
        if (moderationFuture != null) {
            try {
                Moderation moderation = moderationFuture.get();
                if (moderation.flagged()) {
                    throw new ModerationException(String.format("Text \"%s\" violates content policy", moderation.flaggedText()));
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

