/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.loader;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentLoader;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.DocumentSource;
import dev.langchain4j.data.document.source.FileSystemSource;
import dev.langchain4j.internal.Exceptions;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemDocumentLoader {
    private static final Logger log = LoggerFactory.getLogger(FileSystemDocumentLoader.class);

    private FileSystemDocumentLoader() {
    }

    public static Document loadDocument(Path filePath, DocumentParser documentParser) {
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            throw Exceptions.illegalArgument((String)"%s is not a file", (Object[])new Object[]{filePath});
        }
        return DocumentLoader.load((DocumentSource)FileSystemSource.from(filePath), (DocumentParser)documentParser);
    }

    public static Document loadDocument(String filePath, DocumentParser documentParser) {
        return FileSystemDocumentLoader.loadDocument(Paths.get(filePath, new String[0]), documentParser);
    }

    public static List<Document> loadDocuments(Path directoryPath, DocumentParser documentParser) {
        List<Document> list;
        block9: {
            if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
                throw Exceptions.illegalArgument((String)"%s is not a directory", (Object[])new Object[]{directoryPath});
            }
            Stream<Path> pathStream = Files.list(directoryPath);
            try {
                list = FileSystemDocumentLoader.loadDocuments(pathStream, path -> true, directoryPath, documentParser);
                if (pathStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            pathStream.close();
        }
        return list;
    }

    public static List<Document> loadDocuments(String directoryPath, DocumentParser documentParser) {
        return FileSystemDocumentLoader.loadDocuments(Paths.get(directoryPath, new String[0]), documentParser);
    }

    public static List<Document> loadDocuments(Path directoryPath, PathMatcher pathMatcher, DocumentParser documentParser) {
        List<Document> list;
        block9: {
            if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
                throw Exceptions.illegalArgument((String)"%s is not a directory", (Object[])new Object[]{directoryPath});
            }
            Stream<Path> pathStream = Files.list(directoryPath);
            try {
                list = FileSystemDocumentLoader.loadDocuments(pathStream, pathMatcher, directoryPath, documentParser);
                if (pathStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            pathStream.close();
        }
        return list;
    }

    public static List<Document> loadDocuments(String directoryPath, PathMatcher pathMatcher, DocumentParser documentParser) {
        return FileSystemDocumentLoader.loadDocuments(Paths.get(directoryPath, new String[0]), pathMatcher, documentParser);
    }

    public static List<Document> loadDocumentsRecursively(Path directoryPath, DocumentParser documentParser) {
        List<Document> list;
        block9: {
            if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
                throw Exceptions.illegalArgument((String)"%s is not a directory", (Object[])new Object[]{directoryPath});
            }
            Stream<Path> pathStream = Files.walk(directoryPath, new FileVisitOption[0]);
            try {
                list = FileSystemDocumentLoader.loadDocuments(pathStream, path -> true, directoryPath, documentParser);
                if (pathStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            pathStream.close();
        }
        return list;
    }

    public static List<Document> loadDocumentsRecursively(String directoryPath, DocumentParser documentParser) {
        return FileSystemDocumentLoader.loadDocumentsRecursively(Paths.get(directoryPath, new String[0]), documentParser);
    }

    public static List<Document> loadDocumentsRecursively(Path directoryPath, PathMatcher pathMatcher, DocumentParser documentParser) {
        List<Document> list;
        block9: {
            if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
                throw Exceptions.illegalArgument((String)"%s is not a directory", (Object[])new Object[]{directoryPath});
            }
            Stream<Path> pathStream = Files.walk(directoryPath, new FileVisitOption[0]);
            try {
                list = FileSystemDocumentLoader.loadDocuments(pathStream, pathMatcher, directoryPath, documentParser);
                if (pathStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            pathStream.close();
        }
        return list;
    }

    public static List<Document> loadDocumentsRecursively(String directoryPath, PathMatcher pathMatcher, DocumentParser documentParser) {
        return FileSystemDocumentLoader.loadDocumentsRecursively(Paths.get(directoryPath, new String[0]), pathMatcher, documentParser);
    }

    private static List<Document> loadDocuments(Stream<Path> pathStream, PathMatcher pathMatcher, Path pathMatcherRoot, DocumentParser documentParser) {
        ArrayList<Document> documents = new ArrayList<Document>();
        pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(pathMatcherRoot::relativize).filter(pathMatcher::matches).map(pathMatcherRoot::resolve).forEach(file -> {
            try {
                Document document = FileSystemDocumentLoader.loadDocument(file, documentParser);
                documents.add(document);
            }
            catch (Exception e) {
                log.warn("Failed to load document from " + file, (Throwable)e);
            }
        });
        return documents;
    }
}

