/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.chain;

import dev.langchain4j.chain.Chain;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.MessageWindowChatMemory;
import dev.langchain4j.model.chat.ChatLanguageModel;

public class ConversationalChain
implements Chain<String, String> {
    private final ChatLanguageModel chatLanguageModel;
    private final ChatMemory chatMemory;

    private ConversationalChain(ChatLanguageModel chatLanguageModel, ChatMemory chatMemory) {
        this.chatLanguageModel = (ChatLanguageModel)ValidationUtils.ensureNotNull((Object)chatLanguageModel, (String)"chatLanguageModel");
        this.chatMemory = chatMemory == null ? MessageWindowChatMemory.withMaxMessages(10) : chatMemory;
    }

    @Override
    public String execute(String userMessage) {
        this.chatMemory.add((ChatMessage)UserMessage.userMessage((String)ValidationUtils.ensureNotBlank((String)userMessage, (String)"userMessage")));
        AiMessage aiMessage = (AiMessage)this.chatLanguageModel.generate(this.chatMemory.messages()).content();
        this.chatMemory.add((ChatMessage)aiMessage);
        return aiMessage.text();
    }

    public static ConversationalChainBuilder builder() {
        return new ConversationalChainBuilder();
    }

    public static class ConversationalChainBuilder {
        private ChatLanguageModel chatLanguageModel;
        private ChatMemory chatMemory;

        ConversationalChainBuilder() {
        }

        public ConversationalChainBuilder chatLanguageModel(ChatLanguageModel chatLanguageModel) {
            this.chatLanguageModel = chatLanguageModel;
            return this;
        }

        public ConversationalChainBuilder chatMemory(ChatMemory chatMemory) {
            this.chatMemory = chatMemory;
            return this;
        }

        public ConversationalChain build() {
            return new ConversationalChain(this.chatLanguageModel, this.chatMemory);
        }

        public String toString() {
            return "ConversationalChain.ConversationalChainBuilder(chatLanguageModel=" + this.chatLanguageModel + ", chatMemory=" + this.chatMemory + ")";
        }
    }
}

