/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.output;

import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.service.output.EnumOutputParser;
import dev.langchain4j.service.output.OutputParser;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;

abstract class EnumCollectionOutputParser<T extends Enum>
implements OutputParser<Collection<T>> {
    private final Class<? extends Enum> enumClass;
    protected final EnumOutputParser enumOutputParser;

    EnumCollectionOutputParser(Class<? extends Enum> enumClass) {
        this.enumClass = (Class)ValidationUtils.ensureNotNull(enumClass, (String)"enumClass");
        this.enumOutputParser = new EnumOutputParser(enumClass);
    }

    @Override
    public String formatInstructions() {
        try {
            Enum[] enumConstants = this.enumClass.getEnumConstants();
            if (enumConstants.length == 0) {
                throw new IllegalArgumentException("Should be at least one enum constant defined.");
            }
            StringBuilder instruction = new StringBuilder();
            instruction.append("\nYou must answer strictly with zero or more of these enums on a separate line:");
            for (Enum enumConstant : enumConstants) {
                instruction.append("\n").append(enumConstant.name().toUpperCase(Locale.ROOT));
                Optional<String> optionalEnumDescription = EnumOutputParser.getEnumDescription(this.enumClass, enumConstant);
                optionalEnumDescription.ifPresent(description -> instruction.append(" - ").append((String)description));
            }
            return instruction.toString();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

