/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.output;

import dev.langchain4j.Experimental;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.exception.IllegalConfigurationException;
import dev.langchain4j.model.chat.request.json.JsonArraySchema;
import dev.langchain4j.model.chat.request.json.JsonBooleanSchema;
import dev.langchain4j.model.chat.request.json.JsonEnumSchema;
import dev.langchain4j.model.chat.request.json.JsonIntegerSchema;
import dev.langchain4j.model.chat.request.json.JsonNumberSchema;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonStringSchema;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.Result;
import dev.langchain4j.service.TokenStream;
import dev.langchain4j.service.TypeUtils;
import dev.langchain4j.service.output.DefaultOutputParserFactory;
import dev.langchain4j.service.output.OutputParser;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@Experimental
public class JsonSchemas {
    public static Optional<JsonSchema> jsonSchemaFrom(Type returnType) {
        if (TypeUtils.typeHasRawClass(returnType, Result.class)) {
            returnType = TypeUtils.resolveFirstGenericParameterClass(returnType);
        }
        if (returnType == Void.TYPE) {
            throw IllegalConfigurationException.illegalConfiguration("Return type of method '%s' cannot be void");
        }
        if (!JsonSchemas.isPojo(returnType)) {
            return Optional.empty();
        }
        Class<?> rawClass = TypeUtils.getRawClass(returnType);
        JsonSchema jsonSchema = JsonSchema.builder().name(rawClass.getSimpleName()).rootElement((JsonSchemaElement)JsonSchemas.toJsonObjectSchema(rawClass, null)).build();
        return Optional.of(jsonSchema);
    }

    private static boolean isPojo(Type returnType) {
        Class<?> typeArgumentClass;
        if (returnType == String.class || returnType == AiMessage.class || returnType == TokenStream.class || returnType == Response.class) {
            return false;
        }
        Class<?> rawClass = TypeUtils.getRawClass(returnType);
        Optional<OutputParser<?>> outputParser = new DefaultOutputParserFactory().get(rawClass, typeArgumentClass = TypeUtils.resolveFirstGenericParameterClass(returnType));
        return !outputParser.isPresent();
    }

    private static JsonObjectSchema toJsonObjectSchema(Class<?> type, String description) {
        LinkedHashMap<String, JsonSchemaElement> properties = new LinkedHashMap<String, JsonSchemaElement>();
        for (Field field : type.getDeclaredFields()) {
            String fieldName = field.getName();
            if (Modifier.isStatic(field.getModifiers()) || fieldName.equals("__$hits$__") || fieldName.startsWith("this$")) continue;
            String fieldDescription = JsonSchemas.getDescription(field);
            JsonSchemaElement jsonSchemaElement = JsonSchemas.jsonSchema(field.getType(), field.getGenericType(), fieldDescription);
            properties.put(fieldName, jsonSchemaElement);
        }
        return JsonObjectSchema.builder().description(Optional.ofNullable(description).orElse(JsonSchemas.getDescription(type))).properties(properties).required(new ArrayList(properties.keySet())).additionalProperties(Boolean.valueOf(false)).build();
    }

    private static String getDescription(Field field) {
        return JsonSchemas.getDescription(field.getAnnotation(Description.class));
    }

    private static String getDescription(Class<?> type) {
        return JsonSchemas.getDescription(type.getAnnotation(Description.class));
    }

    private static String getDescription(Description description) {
        if (description == null) {
            return null;
        }
        return String.join((CharSequence)" ", description.value());
    }

    private static JsonSchemaElement jsonSchema(Class<?> clazz, Type type, String fieldDescription) {
        if (dev.langchain4j.internal.TypeUtils.isJsonString(clazz)) {
            return JsonStringSchema.builder().description(fieldDescription).build();
        }
        if (dev.langchain4j.internal.TypeUtils.isJsonInteger(clazz)) {
            return JsonIntegerSchema.builder().description(fieldDescription).build();
        }
        if (dev.langchain4j.internal.TypeUtils.isJsonNumber(clazz)) {
            return JsonNumberSchema.builder().description(fieldDescription).build();
        }
        if (dev.langchain4j.internal.TypeUtils.isJsonBoolean(clazz)) {
            return JsonBooleanSchema.builder().description(fieldDescription).build();
        }
        if (clazz.isEnum()) {
            return JsonEnumSchema.builder().enumValues(clazz).description(Optional.ofNullable(fieldDescription).orElse(JsonSchemas.getDescription(clazz))).build();
        }
        if (clazz.isArray()) {
            return JsonArraySchema.builder().items(JsonSchemas.jsonSchema(clazz.getComponentType(), null, null)).description(fieldDescription).build();
        }
        if (clazz.equals(List.class) || clazz.equals(Set.class)) {
            return JsonArraySchema.builder().items(JsonSchemas.jsonSchema(JsonSchemas.getActualType(type), null, null)).description(fieldDescription).build();
        }
        return JsonSchemas.toJsonObjectSchema(clazz, fieldDescription);
    }

    private static Class<?> getActualType(Type type) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        if (type instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length == 1) {
            return (Class)actualTypeArguments[0];
        }
        return null;
    }
}

