/*
 * Decompiled with CFR 0.152.
 */
package fr.noop.charset.iso6937;

import fr.noop.charset.iso6937.Iso6937Charset;
import fr.noop.charset.iso6937.Iso6937CharsetMapping;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.text.Normalizer;

public class Iso6937CharsetEncoder
extends CharsetEncoder {
    public Iso6937CharsetEncoder(Iso6937Charset cs) {
        super(cs, 2.0f, 2.0f);
    }

    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        try {
            while (in.hasRemaining()) {
                char ch = in.get();
                int by = (byte)ch & 0xFF;
                String decomposed = Normalizer.normalize(String.valueOf(ch), Normalizer.Form.NFD);
                if (decomposed.length() == 2) {
                    out.put((byte)Iso6937CharsetMapping.encode(decomposed.charAt(1)));
                    out.put((byte)decomposed.charAt(0));
                    continue;
                }
                by = Iso6937CharsetMapping.encode(by);
                out.put((byte)by);
            }
        }
        catch (BufferOverflowException x) {
            return CoderResult.OVERFLOW;
        }
        return CoderResult.UNDERFLOW;
    }
}

