/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.bitmap.BitmapGlyphInfo;
import com.google.typography.font.sfntly.table.bitmap.EblcTable;
import com.google.typography.font.sfntly.table.bitmap.IndexSubTable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class IndexSubTableFormat4
extends IndexSubTable {
    public static final Comparator<CodeOffsetPair> CodeOffsetPairComparatorByGlyphCode = new CodeOffsetPairGlyphCodeComparator();

    private IndexSubTableFormat4(ReadableFontData data, int firstGlyphIndex, int lastGlyphIndex) {
        super(data, firstGlyphIndex, lastGlyphIndex);
    }

    private static int numGlyphs(ReadableFontData data, int tableOffset) {
        int numGlyphs = data.readULongAsInt(tableOffset + EblcTable.Offset.indexSubTable4_numGlyphs.offset);
        return numGlyphs;
    }

    @Override
    public int numGlyphs() {
        return IndexSubTableFormat4.numGlyphs(this.data, 0);
    }

    @Override
    public int glyphStartOffset(int glyphId) {
        this.checkGlyphRange(glyphId);
        int pairIndex = this.findCodeOffsetPair(glyphId);
        if (pairIndex < 0) {
            return -1;
        }
        return this.data.readUShort(EblcTable.Offset.indexSubTable4_glyphArray.offset + pairIndex * EblcTable.Offset.codeOffsetPairLength.offset + EblcTable.Offset.codeOffsetPair_offset.offset);
    }

    @Override
    public int glyphLength(int glyphId) {
        this.checkGlyphRange(glyphId);
        int pairIndex = this.findCodeOffsetPair(glyphId);
        if (pairIndex < 0) {
            return -1;
        }
        return this.data.readUShort(EblcTable.Offset.indexSubTable4_glyphArray.offset + (pairIndex + 1) * EblcTable.Offset.codeOffsetPairLength.offset + EblcTable.Offset.codeOffsetPair_offset.offset) - this.data.readUShort(EblcTable.Offset.indexSubTable4_glyphArray.offset + pairIndex * EblcTable.Offset.codeOffsetPairLength.offset + EblcTable.Offset.codeOffsetPair_offset.offset);
    }

    protected int findCodeOffsetPair(int glyphId) {
        return this.data.searchUShort(EblcTable.Offset.indexSubTable4_glyphArray.offset, EblcTable.Offset.codeOffsetPairLength.offset, this.numGlyphs(), glyphId);
    }

    public static final class Builder
    extends IndexSubTable.Builder<IndexSubTableFormat4> {
        private List<CodeOffsetPairBuilder> offsetPairArray;

        public static Builder createBuilder() {
            return new Builder();
        }

        static Builder createBuilder(ReadableFontData data, int indexSubTableOffset, int firstGlyphIndex, int lastGlyphIndex) {
            int length = Builder.dataLength(data, indexSubTableOffset, firstGlyphIndex, lastGlyphIndex);
            return new Builder(data.slice(indexSubTableOffset, length), firstGlyphIndex, lastGlyphIndex);
        }

        static Builder createBuilder(WritableFontData data, int indexSubTableOffset, int firstGlyphIndex, int lastGlyphIndex) {
            int length = Builder.dataLength(data, indexSubTableOffset, firstGlyphIndex, lastGlyphIndex);
            return new Builder(data.slice(indexSubTableOffset, length), firstGlyphIndex, lastGlyphIndex);
        }

        private static int dataLength(ReadableFontData data, int indexSubTableOffset, int firstGlyphIndex, int lastGlyphIndex) {
            int numGlyphs = IndexSubTableFormat4.numGlyphs(data, indexSubTableOffset);
            return EblcTable.Offset.indexSubTable4_glyphArray.offset + numGlyphs * EblcTable.Offset.indexSubTable4_codeOffsetPairLength.offset;
        }

        private Builder() {
            super(EblcTable.Offset.indexSubTable4_builderDataSize.offset, 4);
        }

        private Builder(WritableFontData data, int firstGlyphIndex, int lastGlyphIndex) {
            super(data, firstGlyphIndex, lastGlyphIndex);
        }

        private Builder(ReadableFontData data, int firstGlyphIndex, int lastGlyphIndex) {
            super(data, firstGlyphIndex, lastGlyphIndex);
        }

        @Override
        public int numGlyphs() {
            return this.getOffsetArray().size() - 1;
        }

        @Override
        public int glyphLength(int glyphId) {
            this.checkGlyphRange(glyphId);
            int pairIndex = this.findCodeOffsetPair(glyphId);
            if (pairIndex == -1) {
                return -1;
            }
            return this.getOffsetArray().get(pairIndex + 1).offset() - this.getOffsetArray().get(pairIndex).offset();
        }

        @Override
        public int glyphStartOffset(int glyphId) {
            this.checkGlyphRange(glyphId);
            int pairIndex = this.findCodeOffsetPair(glyphId);
            if (pairIndex == -1) {
                return -1;
            }
            return this.getOffsetArray().get(pairIndex).offset();
        }

        public List<CodeOffsetPairBuilder> offsetArray() {
            return this.getOffsetArray();
        }

        private List<CodeOffsetPairBuilder> getOffsetArray() {
            if (this.offsetPairArray == null) {
                this.initialize(super.internalReadData());
                super.setModelChanged();
            }
            return this.offsetPairArray;
        }

        private void initialize(ReadableFontData data) {
            if (this.offsetPairArray == null) {
                this.offsetPairArray = new ArrayList<CodeOffsetPairBuilder>();
            } else {
                this.offsetPairArray.clear();
            }
            if (data != null) {
                int numPairs = IndexSubTableFormat4.numGlyphs(data, 0) + 1;
                int offset = EblcTable.Offset.indexSubTable4_glyphArray.offset;
                for (int i = 0; i < numPairs; ++i) {
                    int glyphCode = data.readUShort(offset + EblcTable.Offset.indexSubTable4_codeOffsetPair_glyphCode.offset);
                    int glyphOffset = data.readUShort(offset + EblcTable.Offset.indexSubTable4_codeOffsetPair_offset.offset);
                    offset += EblcTable.Offset.indexSubTable4_codeOffsetPairLength.offset;
                    CodeOffsetPairBuilder pairBuilder = new CodeOffsetPairBuilder(glyphCode, glyphOffset);
                    this.offsetPairArray.add(pairBuilder);
                }
            }
        }

        private int findCodeOffsetPair(int glyphId) {
            List<CodeOffsetPairBuilder> pairList = this.getOffsetArray();
            int location = 0;
            int bottom = 0;
            int top = pairList.size();
            while (top != bottom) {
                location = (top + bottom) / 2;
                CodeOffsetPairBuilder pair = pairList.get(location);
                if (glyphId < pair.glyphCode()) {
                    top = location;
                    continue;
                }
                if (glyphId > pair.glyphCode()) {
                    bottom = location + 1;
                    continue;
                }
                return location;
            }
            return -1;
        }

        public void setOffsetArray(List<CodeOffsetPairBuilder> array) {
            this.offsetPairArray = array;
            this.setModelChanged();
        }

        @Override
        Iterator<BitmapGlyphInfo> iterator() {
            return new BitmapGlyphInfoIterator();
        }

        @Override
        protected void revert() {
            super.revert();
            this.offsetPairArray = null;
        }

        @Override
        protected IndexSubTableFormat4 subBuildTable(ReadableFontData data) {
            return new IndexSubTableFormat4(data, this.firstGlyphIndex(), this.lastGlyphIndex());
        }

        @Override
        protected void subDataSet() {
            this.revert();
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.offsetPairArray == null) {
                return this.internalReadData().length();
            }
            return EblcTable.Offset.indexSubHeaderLength.offset + FontData.DataSize.ULONG.size() + this.offsetPairArray.size() * EblcTable.Offset.indexSubTable4_codeOffsetPairLength.offset;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return this.offsetPairArray != null;
        }

        @Override
        protected int subSerialize(WritableFontData newData) {
            int size = super.serializeIndexSubHeader(newData);
            if (!this.modelChanged()) {
                size += this.internalReadData().slice(EblcTable.Offset.indexSubTable4_numGlyphs.offset).copyTo(newData.slice(EblcTable.Offset.indexSubTable4_numGlyphs.offset));
            } else {
                size += newData.writeLong(size, this.offsetPairArray.size() - 1);
                for (CodeOffsetPairBuilder pair : this.offsetPairArray) {
                    size += newData.writeUShort(size, pair.glyphCode());
                    size += newData.writeUShort(size, pair.offset());
                }
            }
            return size;
        }

        private class BitmapGlyphInfoIterator
        implements Iterator<BitmapGlyphInfo> {
            private int codeOffsetPairIndex;

            @Override
            public boolean hasNext() {
                return this.codeOffsetPairIndex < Builder.this.getOffsetArray().size() - 1;
            }

            @Override
            public BitmapGlyphInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more characters to iterate.");
                }
                List offsetArray = Builder.this.getOffsetArray();
                CodeOffsetPair pair = (CodeOffsetPair)offsetArray.get(this.codeOffsetPairIndex);
                BitmapGlyphInfo info = new BitmapGlyphInfo(pair.glyphCode(), Builder.this.imageDataOffset(), pair.offset(), ((CodeOffsetPairBuilder)offsetArray.get(this.codeOffsetPairIndex + 1)).offset() - pair.offset(), Builder.this.imageFormat());
                ++this.codeOffsetPairIndex;
                return info;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unable to remove a glyph info.");
            }
        }
    }

    private static final class CodeOffsetPairGlyphCodeComparator
    implements Comparator<CodeOffsetPair> {
        private CodeOffsetPairGlyphCodeComparator() {
        }

        @Override
        public int compare(CodeOffsetPair p1, CodeOffsetPair p2) {
            return p1.glyphCode - p2.glyphCode;
        }
    }

    public static final class CodeOffsetPairBuilder
    extends CodeOffsetPair {
        private CodeOffsetPairBuilder(int glyphCode, int offset) {
            super(glyphCode, offset);
        }

        public void setGlyphCode(int glyphCode) {
            this.glyphCode = glyphCode;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }
    }

    public static class CodeOffsetPair {
        protected int glyphCode;
        protected int offset;

        private CodeOffsetPair(int glyphCode, int offset) {
            this.glyphCode = glyphCode;
            this.offset = offset;
        }

        public int glyphCode() {
            return this.glyphCode;
        }

        public int offset() {
            return this.offset;
        }
    }
}

